/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.workflow.exec.filter;

import com.adobe.granite.workflow.exec.WorkItem;

/**
 * The <code>WorkItemFilter</code> interface allows filter implementations
 * that can be used to filter specific <code>{@link WorkItem}s</code>
 */
public interface WorkItemFilter {
    /**
     * This method returns <code>true</code> if the given <code>{@link WorkItem}</code>
     * matches the filter criteria.
     *
     * @param workItem <code>{@link WorkItem}</code> to check
     *
     * @return <code>true</code> if the given <code>{@link WorkItem}</code>
     * matches the filter criteria.
     */
    boolean doInclude(WorkItem workItem);
}
