/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.workflow.model;

/**
 * <code>WorkflowModelSerializer</code> is the interface for services that
 * provide functionality for de-/serialising
 * {@link WorkflowModel} from/to other (textual) representations.
 */
public interface WorkflowModelSerializer {
	/**
	 * Property for the type serialization type of the
	 * <code>WorkflowModelSerializer</code>.
	 */
	public static final String TYPE = "com.adobe.granite.workflow.serialzer.type";

	/**
	 * Property for the mime type of the serialization format of the
	 * <code>WorkflowModelSerializer</code>.
	 */
	public static final String MIME_TYPE = "com.adobe.granite.workflow.serialzer.mime";

	/**
	 * Returns the type of the <code>WorkflowModelSerializer</code>. Must
	 * return a unique string describing the type of the
	 * <code>WorkflowModelSerializer</code> and serialization format
	 * respectively.
	 * 
	 * @return Unique string identifier for the type of the
	 *         <code>WorkflowModelSerializer</code> and serialization format.
	 */
	String getType();

	/**
	 * Returns the mime type of the <code>WorkflowModelSerializer</code>s
	 * serialization format.
	 * 
	 * @return The mime type of the serialized format.
	 */
	String getMimeType();

	/**
	 * Serializes the given {@link WorkflowModel} into a textual 
	 * representation.
	 * 
	 * @param model 
	 * 			The {@link WorkflowModel} to be serialized.
	 * 
	 * @return A serialized (textual) representation of the 
	 * 			{@link WorkflowModel}.
	 * @throws java.lang.Exception if something goes wrong during serialization
	 */
	String serialize(WorkflowModel model) throws Exception;

	/**
	 * Deserializes a {@link WorkflowModel} instance from the 
	 * given (textual) model definition.
	 * 
	 * @param modelDefinition The model definition as string.
	 * 
	 * @return The deserialized {@link WorkflowModel}.
	 * @throws java.lang.Exception if something goes wrong during deserialization
	 */
	WorkflowModel deserialize(String modelDefinition) throws Exception;
}
