/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2012 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.granite.workflow.serialization;

import com.adobe.granite.workflow.model.WorkflowModel;
import com.adobe.granite.workflow.model.WorkflowModelSerializer;

/**
 * The <code>SerializationService</code> manages access to
 * <code>{@link WorkflowModelSerializer}</code> services.
 */
public interface SerializationService {
	/**
	 * Returns the mime type associated with a given type.
	 * 
	 * @param type
	 *            The type of the serialization format.
	 * 
	 * @return The mime type associated with the given type or NULL if no
	 *         serializer with the given type exists.
	 */
	String getMimeType(String type);

	/**
	 * Serializes the given {@link WorkflowModel} into a textual 
	 * representation.
	 * 
	 * @param model 
	 * 			The {@link WorkflowModel} to be serialized.
	 * @param type The type of the serialization format.
	 * 
	 * @return A serialized (textual) representation of the 
	 * 			{@link WorkflowModel} or NULL if no serializer 
	 * 			with the given type was found.
	 * @throws java.lang.Exception if something goes wrong during serialization
	 */
	String serialize(WorkflowModel model, String type) throws Exception;

	/**
	 * Deserializes a {@link WorkflowModel} instance from the 
	 * given (textual) model definition.
	 * 
	 * @param modelDefinition The model definition as string.
	 * @param type The type of the serialization format.
	 * 
	 * @return The deserialized {@link WorkflowModel} or NULL if 
	 * 			no serializer with the given type was found.
	 * @throws java.lang.Exception if something goes wrong during deserialization
	 */
	WorkflowModel deserialize(String modelDefinition, String type)
			throws Exception;
}
