package com.adobe.internal.io;

import java.io.IOException;
/*
 * This abstract class provides default implementation
 *  for various ByteReader (wrapping a byte writer) methods which can be used by diffrent ByteReader 
 *  implementations which wrap the ByteWriter.
 */
abstract class ByteReaderWrapperImpl implements ByteReader
{
	ByteWriter byteWriter;
	
	/**
	 * @param byteWriter
	 */
	protected ByteReaderWrapperImpl(ByteWriter byteWriter)
	{
		this.byteWriter = byteWriter;
	}

	/**
	 * @see com.adobe.internal.io.ByteReader#read(long)
	 */
	public int read(long position)
		throws IOException
	{
		return this.byteWriter.read(position);
	}

	/**
	 * @see com.adobe.internal.io.ByteReader#read(long, byte[], int, int)
	 */
	public int read(long position, byte[] b, int offset, int length)
		throws IOException
	{
		return this.byteWriter.read(position, b, offset, length);
	}

	/**
	 * @see com.adobe.internal.io.ByteReader#length()
	 */
	public long length()
		throws IOException
	{
		return this.byteWriter.length();
	}

	/**
	 * @see com.adobe.internal.io.ByteReader#close()
	 */
	public void close()
		throws IOException
	{
		this.byteWriter.close();
	}
}
