package com.adobe.internal.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

/**
 * A {@link com.adobe.internal.io.ByteReader ByteReader} that converts
 * a <code>InputStream</code> to either an array of bytes or a <code>RandomAccessFile</code>
 * before wrapping the data with a {@link com.adobe.internal.io.ByteReader ByteReader}.
 *
 * This class is <b>not</b> threadsafe.  It is not safe to pass an instance of this class
 * to multiple threads.  It is not safe to pass an instance of this class to multiple users even
 * if in the same thread.
 */
public class InputStreamByteReader extends ByteReaderWrapperImpl
{
	/**
	 * Creates a new InputStreamByteWriter from the given InputStream.
	 * This reads all of the bytes from the InputStream into memory and then
	 * wraps those bytes with a ByteArrayByteReader.  Once the constructor returns
	 * the stream will have been fully read and closed.
	 * @param inputStream the source of the bytes.
	 * @throws IOException
	 */
	public InputStreamByteReader(InputStream inputStream) throws IOException
	{        
		super(new InputStreamByteWriter(inputStream));
	}
	
	/**
	 * Creates a new InputStreamByteWriter from the given InputStream.
	 * This reads all of the bytes from the InputStream into the
	 * RandomAccessFile provided and then wraps that file with a
	 * RandomAccessFileByteReader.  Once the constructor returns
	 * the stream will have been fully read and closed.  The provided 
	 * RandomAccessFile <b>must</b> have read and write access.
	 * @param inputStream the source of the bytes.
	 * @param raf the location to buffer those bytes to.    
	 * @throws IOException
	 */
	public InputStreamByteReader(InputStream inputStream, RandomAccessFile raf) throws IOException
	{
		super(new InputStreamByteWriter(inputStream, raf));
	}	
}
