/* ****************************************************************************
 *
 *	File: NullOutputByteStream.java
 *
 * ****************************************************************************
 *
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2003-2005 Adobe Systems Incorporated
 *	All Rights Reserved.
 *
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is obtained
 *	from Adobe Systems Incorporated.
 *
 * ***************************************************************************/
package com.adobe.internal.io.stream;

import java.io.IOException;

/**
 * Only for internal engineering use. This api can change without notice.
 */
public class NullOutputByteStream extends OutputByteStreamImpl 
{
	private long length = 0;

	/**
	 * Only for internal engineering use. This api can change without notice.
	 */
	public NullOutputByteStream()
	{
		super();
	}

	/**
	 * Only for internal engineering use. This api can change without notice.
	 */
	public void write(int b)
	throws IOException
	{
		this.seek(this.getPosition() + 1);
		this.length = Math.max(this.getPosition(), this.length);
	}

	public void write(byte[] bytes, int offset, int length)
	throws IOException
	{
		this.seek(this.getPosition() + length);
		this.length = Math.max(this.getPosition(), this.length);
	}

	public long length()
	throws IOException
	{
		return this.length;
	}

	public void close()
	throws IOException
	{
	}

	public void flush()
	throws IOException
	{
	}	
}
