/*
 * File: OutputByteStreamImpl.java
 *
 * ****************************************************************************
 *
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2005 Adobe Systems Incorporated
 *	All Rights Reserved.
 *
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is obtained
 *	from Adobe Systems Incorporated.
 *
 * ***************************************************************************/
package com.adobe.internal.io.stream;

import java.io.IOException;

/**
 * Only for internal engineering use. This api can change without notice.
 * 
 * This class provides access to a seekable output stream.
 * The actual underlying seekable sink is provided by the outside 
 * client as an object that implements the <code>ByteWriter</code> interface.  
 * There can and will be many different implementations of the <code>ByteWriter</code> 
 * interface with different operating characteristics.  So, make no
 * assumptions about the speed of writing and seeking - do so judiciously.
 */
/*package protected*/ abstract class OutputByteStreamImpl implements OutputByteStream
{
	private long position; // absolute offset

	/**
	 * Only for internal engineering use. This api can change without notice.
	 * 
	 * Construct an OutputByteStream from a ByteWriter.
	 */
	OutputByteStreamImpl()
	{
	}

	/* (non-Javadoc)
	 * @see com.adobe.internal.io.stream.OutputByteStream#write(int)
	 */
	abstract public void write(int b)
	throws IOException;

	/* (non-Javadoc)
	 * @see com.adobe.internal.io.stream.OutputByteStream#write(byte[], int, int)
	 */
	abstract public void write(byte[] bytes, int offset, int length)
	throws IOException;

	/* (non-Javadoc)
	 * @see com.adobe.internal.io.stream.OutputByteStream#write(byte[])
	 */
	public void write(byte[] bytes)
	throws IOException
	{
		this.write(bytes, 0, bytes.length);
	}

	/**
	 * Only for internal engineering use. This api can change without notice.
	 * 
	 * Set the current position in the underlying data.
	 * @param position Where to set the current position.
	 * @return This object.
	 * @throws IOException
	 */
	public OutputByteStream seek(long position)
	throws IOException
	{
		if (position < 0)
		{
			position = 0;
		}
		this.position = position;
		return this;
	}

	/* (non-Javadoc)
	 * @see com.adobe.internal.io.stream.OutputByteStream#getPosition()
	 */
	public long getPosition()
	throws IOException
	{
		return this.position;
	}

	/* (non-Javadoc)
	 * @see com.adobe.internal.io.stream.OutputByteStream#eof()
	 */
	public boolean eof()
	throws IOException
	{
		return this.getPosition() >= this.length();
	}

	/* (non-Javadoc)
	 * @see com.adobe.internal.io.stream.OutputByteStream#toOutputStream()
	 */
	public SkippingOutputStream toOutputStream() 
	throws IOException
	{
		//OutputByteStreamImpl obs = new OutputByteStreamImpl(this);
		return new OutputStreamImpl(this);
	}

	/* (non-Javadoc)
	 * @see com.adobe.internal.io.stream.OutputByteStream#closeAndConvert()
	 */
	public InputByteStream closeAndConvert()
	throws IOException
	{
		this.close();
		return null;
	}	
}
