/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2007 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and may be covered by U.S. and Foreign Patents,
 * patents in process, and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/


package com.adobe.internal.io.stream;

import java.io.IOException;

/**
 * This InputByteStreamImpl implementation is only for internal engineering use.
 * It is used only by the digsig package to wrap the digestible slices of the pdf document. The resulting
 * inputStream is used by the verifier interfaces.
 * 
 * @author mdharan
 */
public class RangeInputByteStream extends InputByteStreamImpl 
{
	private ChainedInputByteStream chainedIBS;
	private long[] ranges;

	/**
	 * Create a chainedIBS from the ranges of interest.
	 * @param ibs
	 * @param ranges
	 * @throws IOException 
	 */
	public RangeInputByteStream(InputByteStream ibs, long[] ranges) 
	throws IOException
	{
		InputByteStream[] ibsArray = 
			new InputByteStream[] {ibs.slice(ranges[0], ranges[1]),ibs.slice(ranges[2], ranges[3])};
		this.chainedIBS = new ChainedInputByteStream(ibsArray);
		this.ranges = ranges;

	}

	/**
	 * Only for internal engineering use. This api can change without notice.
	 */
	public void close() 
	throws IOException 
	{
		chainedIBS.close();
		chainedIBS = null;
	}

	/**
	 * Only for internal engineering use. This api can change without notice.
	 */
	public long getPosition() 
	throws IOException 
	{
		return chainedIBS.getPosition();
	}

	/**
	 * Only for internal engineering use. This api can change without notice.
	 */
	public long length() 
	throws IOException 
	{
		return chainedIBS.length();
	}

	/**
	 * Only for internal engineering use. This api can change without notice.
	 */
	public int read() 
	throws IOException 
	{
		return chainedIBS.read();
	}

	/**
	 * Only for internal engineering use. This api can change without notice.
	 */
	public int read(byte[] bytes, int position, int length) 
	throws IOException 
	{
		return chainedIBS.read(bytes, position, length);
	}

	/**
	 * Only for internal engineering use. This api can change without notice.
	 */
	public InputByteStream seek(long position) 
	throws IOException 
	{
		chainedIBS.seek(position);
		return this;
	}

	/** calls slice on underlying ChainedInputByteStream and returns it.
	 * Only for internal engineering use. This api can change without notice.
	 */
	public InputByteStream slice(long begin, long length) 
	throws IOException 
	{
		return chainedIBS.slice(begin, length);
	}

	/**
	 * Only for internal engineering use. This api can change without notice.
	 */
	public ChainedInputByteStream getChainedIBS() 
	{
		return chainedIBS;
	}

	/**
	 * Only for internal engineering use. This api can change without notice.
	 */
	public long[] getRanges() 
	{
		return ranges;
	}
}


