/**
 * 
 */
package com.adobe.internal.io.stream;

import java.io.IOException;
import java.io.OutputStream;

/**
 *	An <code>OutputStream</code> that allows skipping ahead.
 *
 */
public abstract class SkippingOutputStream extends OutputStream
{
	/**
	 * Constructor.
	 */
	protected SkippingOutputStream()
	{
		super();
	}

	/**
	 * Skip ahead in the stream from the current position.
	 * 
	 * @param count number of bytes to skip ahead from the current position
	 * @throws IOException 
	 */
	public abstract void skip(long count) throws IOException;
}
