/*
 * File: CosListLong.java
 *
 * ****************************************************************************
 *
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2003-2006 Adobe Systems Incorporated
 *	All Rights Reserved.
 *
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is obtained
 *	from Adobe Systems Incorporated.
 *
 * ***************************************************************************/

package com.adobe.internal.pdftoolkit.core.cos;

/**
 * Just like CosList, except for primitive long values.
 */
final class CosListLong
{
	// Parameters
	private static final int NUM_LOW_BITS = 5;
	private static final int BLOCK_SIZE = 1 << NUM_LOW_BITS;
	private static final int BLOCK_SIZE_MASK = (1 << NUM_LOW_BITS) - 1;

	// Per object storage
	private int mMasterBlockSize;
	private long[][] mBlockList;

	// Constructor does nothing except allocate master block
	CosListLong()
	{
		mMasterBlockSize = 32;
		mBlockList = new long[mMasterBlockSize][];
	}

	void add(int index, long value)
	{
		int blockIndex = index >> NUM_LOW_BITS;
		if (blockIndex >= mMasterBlockSize) {
			int newSize = mMasterBlockSize;
			while (blockIndex >= newSize)
				newSize *= 2;
			long[][] newList = new long[newSize][];
			for (int i = 0; i < mMasterBlockSize; i++)
				newList[i] = mBlockList[i];
			mMasterBlockSize = newSize;
			mBlockList = newList;
		}
		long[] block = mBlockList[blockIndex];
		if (block == null) {
			block = new long[BLOCK_SIZE];
			mBlockList[blockIndex] = block;
		}
		block[index & BLOCK_SIZE_MASK] = value;
	}

	long get(int index)
	{
		int blockIndex = index >> NUM_LOW_BITS;
		if (blockIndex >= mMasterBlockSize)
			return 0;
		long[] block = mBlockList[blockIndex];
		if (block == null)
			return 0;
		return block[index & BLOCK_SIZE_MASK];
	}
}
