/* ****************************************************************************
 *
 *	File: CosNull.java
 *
 * ****************************************************************************
 *
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2003-2005 Adobe Systems Incorporated
 *	All Rights Reserved.
 *
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is obtained
 *	from Adobe Systems Incorporated.
 *
 * ***************************************************************************/

package com.adobe.internal.pdftoolkit.core.cos;

import java.io.IOException;

import com.adobe.internal.io.stream.OutputByteStream;

/**
 * Represents a COS null object as defined in section 3.2.8 of the PDF
 * Reference Manual version 1.4.
 */
public class CosNull extends CosScalar
{
	private static final byte[] NULL = {'n', 'u', 'l', 'l' };
	
	/**
	 * Constructs a COS null object
	 *
	 * @param doc	Document which contains the null object
	 */
	CosNull(CosDocument doc)
	{
		super(doc, null);
	}

	/**
	 * 
	 * return the type of this CosObject
	 */
	@Override
	public int getType()
	{
		return t_Null;
	}

	
	@Override
	void writeOut(OutputByteStream outStream, boolean inString, boolean inDebugMode)
	throws IOException
	{
		outStream.write(NULL);
	}

	
	@Override
	public Object getValue()
	{
		return null;
	}
	/**
	 *  This method always returns true except when passed Cosobject is not 
	 *  an instance of CosNull or not on the same document.
	 *  @param value
	 *  @return boolean
	 */
	@Override
	public boolean equals(CosObject value){
		return !(!(value instanceof CosNull) || value.getDocument() != this.getDocument());
	}
}
