/* ****************************************************************************
 *
 *	File: CosScalarOps.java
 *
 * ****************************************************************************
 *
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2003-2005 Adobe Systems Incorporated
 *	All Rights Reserved.
 *
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is obtained
 *	from Adobe Systems Incorporated.
 *
 * ***************************************************************************/

package com.adobe.internal.pdftoolkit.core.cos;


import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;

/**
 *   class:  CosScalarOps
 *
 * describtion:
 *
 *
 * change history:
 */
public class CosScalarOps
{

	private static int compareTo(CosNumeric a, CosNumeric b)
	{
		Number aNumber = (Number)(a.getValue());
		Number bNumber = (Number)(b.getValue());
		if (aNumber instanceof Double || aNumber instanceof Float)
			return (int)(aNumber.doubleValue() - bNumber.doubleValue());
		return (int)(aNumber.longValue() - bNumber.longValue());
	}

	
	private static int compareTo(CosString a, CosString b)
		throws PDFSecurityException
	{
		byte v1[] = a.byteArrayValue();
		byte v2[] = b.byteArrayValue();
		int len1 = v1.length;
		int len2 = v2.length;
		int n = Math.min(len1, len2);
		int k = 0;
		while (k < n) {
			if (v1[k] != v2[k]) {
				return (v1[k]&0xff) - (v2[k]&0xff);
			}
			k++;
		}
		// If they are the same so far then the longer one is "greater".
		return len1 - len2;
	}

	/**
	 * This method checks the internal content of cos scalers to compare them.
	 * @throws PDFSecurityException
	 */
	public static int compareTo(CosScalar a, CosScalar b)
		throws PDFSecurityException
	{
		if (a == b) return 0;
		if (a instanceof CosString)
			if (b instanceof CosString)
				return compareTo((CosString)a, (CosString)b);
		if (a instanceof CosNumeric)
			if (b instanceof CosNumeric)
				return compareTo((CosNumeric)a, (CosNumeric)b);
		return 0;
	}
	
	/**
	 * @throws PDFSecurityException
	 */
	private static boolean equivalent(CosString a, CosString b)
		throws PDFSecurityException
	{
		if (compareTo(a, b) != 0)
			return false;
		return true;
	}

	
	private static boolean equivalent(CosNumeric a, CosNumeric b)
	{
		Number bNumber = b.numberValue();
		Number aNumber = a.numberValue();
		return bNumber.equals(aNumber);
	}

	/**
	 * This method checks the equivalency of the cos scalers passed here. 
	 * @throws PDFSecurityException
	 */
	public static boolean equivalent(CosScalar a, CosScalar b)
		throws PDFSecurityException
	{
		if (a == b) return true;
		if (a instanceof CosString) {
			if (b instanceof CosString)
				return equivalent((CosString)a, (CosString)b);
			return false;
		}
		if (a instanceof CosNumeric) {
			if (b instanceof CosNumeric)
				return equivalent((CosNumeric)a, (CosNumeric)b);
			return false;
		}
		return false;
	}
}
