/* File: HSMCredentials.java
*  
* ****************************************************************************
*
*	ADOBE CONFIDENTIAL
*	___________________
*
*	Copyright 2006 Adobe Systems Incorporated
*	All Rights Reserved.
*
*	NOTICE: All information contained herein is, and remains the property of
*	Adobe Systems Incorporated and its suppliers, if any. The intellectual
*	and technical concepts contained herein are proprietary to Adobe Systems
*	Incorporated and its suppliers and may be covered by U.S. and Foreign
*	Patents, patents in process, and are protected by trade secret or
*	copyright law. Dissemination of this information or reproduction of this
*	material is strictly forbidden unless prior written permission is obtained
*	from Adobe Systems Incorporated.
*
* ***************************************************************************/
package com.adobe.internal.pdftoolkit.core.credentials.impl;


import com.rsa.jsafe.JSAFE_Session;

/**
 * HSMCredentials contains the key handle, session spec and certificates required for signing on an hardware device.
 * @author mdharan
 *
 */
public class HSMCredentials extends RSACredentials
{
	
	JSAFE_Session[] session;
	boolean useCustomDB = false;

	
	public HSMCredentials(HSMPrivateKey privateKey, com.rsa.certj.cert.X509Certificate cert, com.rsa.certj.cert.Certificate[] certChain) 
	{
		super(privateKey.getJsafeKey(), cert, certChain);
		this.session = privateKey.getSession();
	}


	public JSAFE_Session[] getSession() {
		return session;
	}

	public void setSession(JSAFE_Session[] session) {
		this.session = session;
	}

	/**
	 * The CustomDB provider implementation will be used during HSM signing if this method is called.
	 *
	 */
	public void enableCustomDB() 
	{
		this.useCustomDB = true;
	}



	/**
	 * This may later be changed to accept a Custom DB provider implementation.
	 * For now this is a way for our clients to see if using our own custom db provides
	 * performance improvements during HSM signing.
	 
	 */
	public void disableCustomDB() 
	{
		this.useCustomDB = false;
	}
	
	public boolean getCustomDBPref()
	{
		return this.useCustomDB;
	}
	
	

}
