/*
 * File: PDFCosNumberParseRuntimeException.java
 * ************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * ___________________
 *
 *  Copyright 2011 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.internal.pdftoolkit.core.exceptions;

/**
 * This runtime exception is thrown, when any method is called on an incorrectly parsed cos-number. 
 * @author hraghav
 */
public class PDFCosNumberParseRuntimeException extends PDFRuntimeException
{
	private static final long serialVersionUID = 2187022273535592608L;

	/**
	 * Constructor with a string message 
	 */
	public PDFCosNumberParseRuntimeException(String message)
	{
		super(message);
	}
	
	/**
	 * Creates a PDFCosNumberParseRuntimeException by wrapping a PDFCosParseException
	 */
	public PDFCosNumberParseRuntimeException(PDFCosParseException ex)
	{
		super(ex);
	}
}
