/*
 *
 *	File: PDFCosParseException.java
 *
 *
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2005 Adobe Systems Incorporated
 *	All Rights Reserved.
 *
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is obtained
 *	from Adobe Systems Incorporated.
 *
 */
package com.adobe.internal.pdftoolkit.core.exceptions;

import java.util.HashSet;
import java.util.Set;

/**
 * This exception indicates a low level parsing problem at the Cos
 * level has occurred.  This should never be exposed to client level API.
 * Only the Cos layer and any method which takes a Cos object should throw
 * this.  Other methods should wrap it as appropriate - 
 * often with  PDFInvalidDocumentException.
 */
public class PDFCosParseException extends PDFInvalidDocumentException
{
	/**
	 * This is a default serialVersionUID.
	 */
	private static final long serialVersionUID = 1L;

	/**
	 * This enum contains the possible errors which can occur while parsing PDf document.
	 * The future plan is to add more such error types which can not be repaired. Currently,
	 * it has only number parsing error. 
	 * @author hkansal
	 *
	 */
	public static enum CosParseErrorType {
		NumberParseError
	}
	private Set<CosParseErrorType> errorTypes = new HashSet<CosParseErrorType>();
	
	public boolean hasErrorType(CosParseErrorType type) {
		return errorTypes.contains(type);
	}

	public void addErrorType(CosParseErrorType errorType) {
		this.errorTypes.add(errorType);
	}

	/**
     * Create a new PDFCosParseException.
     * @param message the detail message.
     */
    public PDFCosParseException(String message)
    {
        super(message);
    }

    /**
     * Create a new PDFCosParseException wrapping an existing exception.
     * @param message the detail message.
     * @param cause the cause.
     */
    public PDFCosParseException(String message, Throwable cause)
    {
        super(message, cause);
    }

    /**
     * Create a new PDFCosParseException wrapping an existing exception.
     * @param cause the cause.
     */
    public PDFCosParseException(Throwable cause)
    {
        super(cause);
    }
}
