/*
 *
 *	File: PDFIOException.java
 *
 *
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2005 Adobe Systems Incorporated
 *	All Rights Reserved.
 *
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is obtained
 *	from Adobe Systems Incorporated.
 *
 */
package com.adobe.internal.pdftoolkit.core.exceptions;


/**
 * An I/O error has occurred during the reading or writing of the PDF file
 * or in the reading or writing of temporary caches of PDF data.
 */
public class PDFIOException extends PDFException
{
	/**
	 * This is a default serialVersionUID.
	 */
	private static final long serialVersionUID = 1L;

	/**
     * Create a new PDFIOException.
     * @param message the detail message.
     */
    public PDFIOException(String message)
    {
        super(message);
    }

    /**
     * Create a new PDFIOException wrapping an existing exception.
     * @param message the detail message.
     * @param cause the cause.
     */
    public PDFIOException(String message, Throwable cause)
    {
        super(message, cause);
    }

    /**
     * Create a new PDFIOException wrapping an existing exception.
     * @param cause the cause.
     */
    public PDFIOException(Throwable cause)
    {
        super(cause);
    }
}
