/*
 *
 *	File: PDFSecurityConfigurationException.java
 *
 *
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2005 Adobe Systems Incorporated
 *	All Rights Reserved.
 *
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is obtained
 *	from Adobe Systems Incorporated.
 *
 */
package com.adobe.internal.pdftoolkit.core.exceptions;


/**
 * This exception indicates that a request has failed due not being able to get
 * authorization for the request or one of the actions required by that request from
 * the {@link com.adobe.internal.pdftoolkit.core.securityframework.SecurityHandler SecurityHandler}.
 * 
 * While the Adobe PDF Java  Toolkit may only declare that they throw a PDFSecurityException
 * in their method declaration that exception may be one of the descendant exceptions
 * such as this one.  If a client wishes to know more about the reason for failure they
 * can add <code>catch</code> clauses for specific subclass exceptions such as this one.
 */
public class PDFSecurityAuthorizationException extends PDFSecurityException
{
	/**
	 * This is a default serialVersionUID.
	 */
	private static final long serialVersionUID = 1L;

	/**
     * Create a new PDFSecurityAuthorizationException.
     * @param message the detail message.
     */
    public PDFSecurityAuthorizationException(String message)
    {
        super(message);
    }

    /**
     * Create a new PDFSecurityAuthorizationException wrapping an existing exception.
     * @param message the detail message.
     * @param cause the cause.
     */
    public PDFSecurityAuthorizationException(String message, Throwable cause)
    {
        super(message, cause);
    }

    /**
     * Create a new PDFSecurityAuthorizationException wrapping an existing exception.
     * @param cause the cause.
     */
    public PDFSecurityAuthorizationException(Throwable cause)
    {
        super(cause);
    }
}
