/*
 *
 *	File: PDFUnableToCompleteOperationException.java
 *
 *
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2005 Adobe Systems Incorporated
 *	All Rights Reserved.
 *
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is obtained
 *	from Adobe Systems Incorporated.
 *
 */
package com.adobe.internal.pdftoolkit.core.exceptions;


/**
 * This exception indicates that an error has occurred which is not
 * mappable into one of the other exception classes.  This could be a
 * variety of things such as invalid/inconsistent internal state of an
 * object, erroneous hard-coded internal data, or unmappable exceptions that
 * are thrown from external libraries (the JDK or Jars).
 */
public class PDFUnableToCompleteOperationException extends PDFException
{
	/**
	 * This is a default serialVersionUID.
	 */
	private static final long serialVersionUID = 1L;

	/**
     * Create a new PDFUnableToCompleteOperationException.
     * @param message the detail message.
     */
    public PDFUnableToCompleteOperationException(String message)
    {
        super(message);
    }

    /**
     * Create a new PDFUnableToCompleteOperationException wrapping an existing exception.
     * @param message the detail message.
     * @param cause the cause.
     */
    public PDFUnableToCompleteOperationException(String message,
            Throwable cause)
    {
        super(message, cause);
    }

    /**
     * Create a new PDFUnableToCompleteOperationException wrapping an existing exception.
     * @param cause the cause.
     */
    public PDFUnableToCompleteOperationException(Throwable cause)
    {
        super(cause);
    }
}
