/* $Header: /Faultline/com/adobe/acrobat/filters/DCTjframe.java 1 $ */
/*
  DCTjframe.java

  The various structures used by the JPEG encoder and decoder
  Split into multiple files

*/
package com.adobe.internal.pdftoolkit.core.filter;


/* The jframe struct contains information associated with a component that
 does not change between scans.  This includes the sampling parameters,
 location of the storage for the component (allocated only once; does not
 change between scans), pointer to the quantization table (also does not
 change between scans).  The frameComponentId is an Id assigned to a
 component; some JPEG implementations use these Id's to identify particular
 components such as Red or Luminance.  However, this implementation does not
 have any convention; this DCTEncode just assigns the Id's [1..4] to the colors
 [0..3].  frameQTNum is the index number of the quantization table; qmat
 and dqmat are pointers derived from frameQTNum.

 The decoder has code which matches up scanComponentId==j with
 frameComponenetId==i.

 Usage of the components: hs, vs, prev_dc, padx, strip, big, coefx, coefy,
 padfill, and frameComponentId are used by both coder and decoder.

 maxSampling is used inside dctcmmn.c to figure out the vFast and hFast
 parameters (i.e., by both encoder and decoder), and, only when the
 EnableAClip compile switch is 1, it is used inside dctecore.c.

 cols, and all items inside StudyQErr and SummarizeQXFSizes are used only by
 the encoder.
 */

class DCTjframe
{
    int hs;           /* horizontal sampling */
    int vs;           /* vertical sampling */
    int padx;         /* no. bytes per strip scan line */
    short strip[];    /* strip of color samples. (can be short[] or byte[]) */
    boolean maxSampling;  /* 1 if this component has max. hs and max. vs.
                         Used in dctecore.c only for EnableAClip == 1.
                         Used in dctcmmn.c for dg->vFast init. */
    DCTStripPtrRec stripPtrs[];

//#if QuantCoefRaster
    int coefx;        /* comp. image size: no. coef. wide */
    int coefy;        /* comp. image size: no. coef. high */
    Object qcoef;     /* raster of quantized coefficients (can be short[] or byte[]) */
    boolean qcSmall;  /* 1 if qcoef is ASInt8P, 0 if ASInt16P. */
//#endif /* QuantCoefRaster */
    int frameComponentId;
    int frameQTNum;
    int cols;          /* column of last real pixel in [0..8] */
    int qmat[];        /* Scaled zig-zag order quant. table */
}
