/*
 * File: LZWInputStream.java
 *
 * ****************************************************************************
 *
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2003-2005 Adobe Systems Incorporated
 *	All Rights Reserved.
 *
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is obtained
 *	from Adobe Systems Incorporated.
 *
 * ***************************************************************************/

package com.adobe.internal.pdftoolkit.core.filter;

import java.io.InputStream;

/**
 * LZWInputStream
 *
 * Copyright (C) 1996-2005 Adobe Systems Incorporated
 */
public class LZWInputStream extends DecodeInputStream
{
	// Variables
	private LZWEngine	lzw;

	// Constructors
	/**
	 * Creates an input stream filter.
	 * @param in	the input stream
	 */
	public LZWInputStream(InputStream in, int inSize, int outSize,  FilterParams diparams)
	{
		super(in, inSize, outSize, 0, diparams);
		lzw = new LZWEngine(in);
		if (diparams.containsKey(FilterParams.EarlyChange_K))
			lzw.setEarlyChange(((Integer)diparams.get(FilterParams.EarlyChange_K)).intValue());
	}

	public LZWInputStream(InputStream  in, FilterParams p)
	{
		super(in, 0, p);
		lzw = new LZWEngine(this);
		if (diparams.containsKey(FilterParams.EarlyChange_K))
			lzw.setEarlyChange(((Integer)diparams.get(FilterParams.EarlyChange_K)).intValue());
	}

	public LZWInputStream(InputStream  in)
	{
		this(in, null);
	}

	// Methods
	/* Used by lzw.get */
	int read1()
	{
		if (inCount <= inPos) {
			if (!fillInputBuffer()) {
				return -1;
			}
		}
			return (inBuf[inPos++] & 0xFF);
	}

	int read2()
	{
		if (inCount - inPos >= 2) {
			inPos += 2;
			return ((inBuf[inPos-2] & 0xFF) << 8) + (inBuf[inPos-1] & 0xFF);
			}
			else
				return -1;  /* Indicate that 2 bytes aren't available */
	}

	int read3()
	{
		if (inCount - inPos >= 3) {
			inPos += 3;
			return ((inBuf[inPos-3] & 0xFF) << 16) + ((inBuf[inPos-2] & 0xFF) << 8) + (inBuf[inPos-1] & 0xFF);
			}
			else
				return -1;  /* Indicate that 3 bytes aren't available */
	}

	@Override
	public void fill()
	{
		int count;

		fillLoop:
		while (outCount < outBuf.length && !pendingEOF && pendingException == null) {
			count = lzw.get(outBuf, outCount, outBuf.length - outCount);
			outCount += count;

			if (count == 0) {
				pendingEOF = true;
				break fillLoop;
			}
		}
	}

	@Override
	public int getInPos()
	{
		if (in instanceof DecodeInputStream)
			return ((DecodeInputStream)in).getInPos();
		return inTotal + inPos - (lzw.getResidualBits() / 8);
	}
}
