package com.adobe.internal.pdftoolkit.core.filter;

import java.io.InputStream;


/**
 * RunLengthInputStream
 *
 *	Important: This filter assumes the input stream is an ISO/Latin-1
 *	stream, of 1-byte (not Unicode) characters!
 *
 * Copyright (C) 1996 Adobe Systems Incorporated
 */
public class RunLengthInputStream extends DecodeInputStream
{
		// Variables
	private static final int	ED = 128;	/* EOD */

//	private boolean	repeat;
//	private int		count;
//	private int		repeatChar;


	// Constructors
    /**
     * Creates an input stream filter.
     * @param in	the input stream
     */
    public RunLengthInputStream(
        InputStream in,
        int         inSize,
        int         outSize,
        FilterParams diparams )
    {
        super(in, inSize, outSize, 128, diparams);
    }

    public RunLengthInputStream(InputStream  in, FilterParams p)
    {
        super(in, 128, p);
    }

    public RunLengthInputStream(InputStream  in)
	{
		this(in, null);
	}


    @Override
	public void fill()
    {
		int		count, newChar;

        fillLoop:
        while (outCount <= (outBuf.length - 128) &&
               !pendingEOF && pendingException == null)
        {
            if ( inCount <= inPos ) {
                if (!fillInputBuffer()) {
                    pendingException =
                        new RunLengthFilterException("RunLength missing EOF");
                    break fillLoop;
                }
            }
    		count = inBuf[inPos++] & 0xFF;

			if (count == ED) {
				pendingEOF = true;
                break fillLoop;
			}
			else if (count > ED) {
				count = 256 - count;

                if ( inCount <= inPos ) {
                    if (!fillInputBuffer()) {
                        pendingException =
                            new RunLengthFilterException("RunLength no repeat char");
                        break fillLoop;
                    }
                }
				newChar = inBuf[inPos++] & 0xFF;

				while (count-- >= 0)
				    outBuf[outCount++] = (byte)newChar;
			}
			else {
				while (count-- >= 0) {
                    if ( inCount <= inPos ) {
                        if (!fillInputBuffer()) {
                            pendingException =
                                new RunLengthFilterException("RunLength no run char");
                            break fillLoop;
                        }
                    }
    				newChar = inBuf[inPos++] & 0xFF;
    				outBuf[outCount++] = (byte)newChar;
    			}
    		}
    	}
    }
}

