/*
 * File: CustomDecodeFilter.java
 *  
 * ****************************************************************************
 *
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2008 Adobe Systems Incorporated
 *	All Rights Reserved.
 *
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is obtained
 *	from Adobe Systems Incorporated.
 *
 * ***************************************************************************/

package com.adobe.internal.pdftoolkit.core.filter.spi;

import java.io.InputStream;

import com.adobe.internal.pdftoolkit.core.filter.FilterParams;

/**
 * Declares the functionality needed for creating a custom decode filter.
 * @author mdharan
 *
 */
public interface CustomDecodeFilter extends CustomFilter
{
	/**
	 * Decode the stream applying the required filter and using
	 * the supplied filter parameters if needed.
	 * @param in
	 * @param filterParams
	 * @return decoded bytes in an input stream.
	 * @throws CustomFilterException
	 */
	public InputStream decode(InputStream in, FilterParams filterParams) throws CustomFilterException;
	
	

}
