/*
 * File: CustomEncodeFilter.java
 *  
 * ****************************************************************************
 *
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2008 Adobe Systems Incorporated
 *	All Rights Reserved.
 *
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is obtained
 *	from Adobe Systems Incorporated.
 *
 * ***************************************************************************/

package com.adobe.internal.pdftoolkit.core.filter.spi;

import java.io.OutputStream;

import com.adobe.internal.pdftoolkit.core.filter.FilterParams;

/**
 * Declares the functionality needed for creating a custom encode filter.
 * @author mdharan
 *
 */
public interface CustomEncodeFilter extends CustomFilter
{
	/**
	 * This method returns an output stream which is responsible for encoding all the bytes written to that stream in the future and also write
	 * those encoded bytes on the output stream passed here.
	 * All the parameters required while encoding are present in filterParams object.
	 * @param dstStm
	 * @param filterParams
	 * @throws CustomFilterException
	 * @return encoded bytes in an output stream.
	 */
	public OutputStream encode(OutputStream dstStm, FilterParams filterParams) throws CustomFilterException;
	
	/**
	 * Updates the filterParams based on capability of the custom encode filter 
	 * @param fParams
	 * @return upadated FilterParams
	 */
	public FilterParams updateFilterParams(FilterParams fParams);
	

}
