/*
* File: CoreFontUtils.java
*
*************************************************************************
** ADOBE CONFIDENTIAL
* ___________________
*
*  Copyright 2012 Adobe Systems Incorporated
*  All Rights Reserved.
*
* NOTICE:  All information contained herein is, and remains
* the property of Adobe Systems Incorporated and its suppliers,
* if any.  The intellectual and technical concepts contained
* herein are proprietary to Adobe Systems Incorporated and its
* suppliers and are protected by trade secret or copyright law.
* Dissemination of this information or reproduction of this material
* is strictly forbidden unless prior written permission is obtained
  from Adobe Systems Incorporated.
**************************************************************************/
package com.adobe.internal.pdftoolkit.core.fontset.impl;

import java.util.HashMap;

import com.adobe.internal.pdftoolkit.core.types.ASName;

/**
 * This class contains some utility methods related to standard fonts.
 * @author hkansal
 *
 */
public class CoreFontUtils {
	
	protected CoreFontUtils(){}
	private static final String[] timesFamilyNames = { ASName.k_Times_Roman.asString(),
		ASName.k_TimesNewRomanPSMT.asString(), ASName.k_TimesNewRoman.asString(),
		ASName.k_TimesNewRomanPS.asString() };
	private static final String[] timesBoldFamilyNames = { ASName.k_Times_Bold.asString(),
			ASName.k_TimesNewRomanPS_BoldMT.asString(), ASName.k_TimesNewRomanCommaBold.asString(),
			ASName.k_TimesNewRomanPS_Bold.asString(), ASName.k_TimesNewRoman_Bold.asString() };
	private static final String[] timesItalicFamilyNames = {
			ASName.k_Times_Italic.asString(), ASName.k_TimesNewRomanPS_ItalicMT.asString(),
			ASName.k_TimesNewRomanCommaItalic.asString(), ASName.k_TimesNewRomanPS_Italic.asString(),
			ASName.k_TimesNewRoman_Italic.asString() };
	private static final String[] timesBoldItalicFamilyNames = {
			ASName.k_Times_BoldItalic.asString(), ASName.k_TimesNewRomanPS_BoldItalicMT.asString(),
			ASName.k_TimesNewRomanCommaBoldItalic.asString(),
			ASName.k_TimesNewRomanPS_BoldItalic.asString(),
			ASName.k_TimesNewRoman_BoldItalic.asString() };
	private static final String[] helveticaFamilyNames = { ASName.k_Helvetica.asString(),
			ASName.k_ArialMT.asString(), ASName.k_Arial.asString() };
	private static final String[] helveticaBoldFamilyNames = {
			ASName.k_Helvetica_Bold.asString(), ASName.k_Arial_BoldMT.asString(),
			ASName.k_ArialCommaBold.asString(), ASName.k_Arial_Bold.asString(),
			ASName.k_HelveticaCommaBold.asString() };
	private static final String[] helveticaItalicFamilyNames = {
			ASName.k_Helvetica_Oblique.asString(), ASName.k_Arial_ItalicMT.asString(),
			ASName.k_ArialCommaItalic.asString(), ASName.k_Arial_Italic.asString(),
			ASName.k_HelveticaCommaItalic.asString(), ASName.k_Helvetica_Italic.asString() };
	private static final String[] helveticaBoldItalicFamilyNames = {
			ASName.k_Helvetica_BoldOblique.asString(), ASName.k_Arial_BoldItalicMT.asString(),
			ASName.k_ArialCommaBoldItalic.asString(), ASName.k_Arial_BoldItalic.asString(),
			ASName.k_HelveticaCommaBoldItalic.asString(), ASName.k_Helvetica_BoldItalic.asString() };
	private static final String[] courierFamilyNames = { ASName.k_Courier.asString(),
			ASName.k_CourierNew.asString(), ASName.k_CourierNewPSMT.asString() };
	private static final String[] courierBoldFamilyNames = {
			ASName.k_Courier_Bold.asString(), ASName.k_CourierNewCommaBold.asString(),
			ASName.k_CourierCommaBold.asString(), ASName.k_CourierNewPS_BoldMT.asString(),
			ASName.k_CourierNew_Bold.asString() };
	private static final String[] courierItalicFamilyNames = {
			ASName.k_Courier_Oblique.asString(), ASName.k_CourierNewCommaItalic.asString(),
			ASName.k_CourierCommaItalic.asString(), ASName.k_CourierNewPS_ItalicMT.asString(),
			ASName.k_CourierNew_Italic.asString() };
	private static final String[] courierBoldItalicFamilyNames = {
			ASName.k_Courier_BoldOblique.asString(), ASName.k_CourierNewCommaBoldItalic.asString(),
			ASName.k_CourierCommaBoldItalic.asString(),
			ASName.k_CourierNewPS_BoldItalicMT.asString(), ASName.k_CourierNew_BoldItalic.asString() };
	private static final String[] symbolFamilyNames = {
		 	ASName.k_Symbol.asString(), "Symb" };
	private static final String[] zapfDingbatsFamilyNames = {
			ASName.k_ZapfDingbats.asString(), "ZaDb" };
	public static final HashMap<ASName, ASName> standardFontsNames = new HashMap<ASName, ASName>(
			16, .5f);
	static {
		for(int i=0;i<timesFamilyNames.length;i++)
		{
			standardFontsNames.put(ASName.create(timesFamilyNames[i]), ASName.create(timesFamilyNames[0]));
		}
		for(int i=0;i<timesBoldFamilyNames.length;i++)
		{
			standardFontsNames.put(ASName.create(timesBoldFamilyNames[i]), ASName.create(timesBoldFamilyNames[0]));
		}
		for(int i=0;i<timesItalicFamilyNames.length;i++)
		{
			standardFontsNames.put(ASName.create(timesItalicFamilyNames[i]), ASName.create(timesItalicFamilyNames[0]));
		}
		for(int i=0;i<timesBoldItalicFamilyNames.length;i++)
		{
			standardFontsNames.put(ASName.create(timesBoldItalicFamilyNames[i]), ASName.create(timesBoldItalicFamilyNames[0]));
		}
		for(int i=0;i<helveticaFamilyNames.length;i++)
		{
			standardFontsNames.put(ASName.create(helveticaFamilyNames[i]), ASName.create(helveticaFamilyNames[0]));
		}
		for(int i=0;i<helveticaBoldFamilyNames.length;i++)
		{
			standardFontsNames.put(ASName.create(helveticaBoldFamilyNames[i]), ASName.create(helveticaBoldFamilyNames[0]));
		}
		for(int i=0;i<helveticaItalicFamilyNames.length;i++)
		{
			standardFontsNames.put(ASName.create(helveticaItalicFamilyNames[i]), ASName.create(helveticaItalicFamilyNames[0]));
		}
		for(int i=0;i<helveticaBoldItalicFamilyNames.length;i++)
		{
			standardFontsNames.put(ASName.create(helveticaBoldItalicFamilyNames[i]), ASName.create(helveticaBoldItalicFamilyNames[0]));
		}
		for(int i=0;i<courierFamilyNames.length;i++)
		{
			standardFontsNames.put(ASName.create(courierFamilyNames[i]), ASName.create(courierFamilyNames[0]));
		}
		for(int i=0;i<courierBoldFamilyNames.length;i++)
		{
			standardFontsNames.put(ASName.create(courierBoldFamilyNames[i]), ASName.create(courierBoldFamilyNames[0]));
		}
		for(int i=0;i<courierItalicFamilyNames.length;i++)
		{
			standardFontsNames.put(ASName.create(courierItalicFamilyNames[i]), ASName.create(courierItalicFamilyNames[0]));
		}
		for(int i=0;i<courierBoldItalicFamilyNames.length;i++)
		{
			standardFontsNames.put(ASName.create(courierBoldItalicFamilyNames[i]), ASName.create(courierBoldItalicFamilyNames[0]));
		}
		for(int i=0;i<symbolFamilyNames.length;i++)
		{
			standardFontsNames.put(ASName.create(symbolFamilyNames[i]), ASName.create(symbolFamilyNames[0]));
		}
		for(int i=0;i<zapfDingbatsFamilyNames.length;i++)
		{
			standardFontsNames.put(ASName.create(zapfDingbatsFamilyNames[i]), ASName.create(zapfDingbatsFamilyNames[0]));
		}
	}
	/**
	 * Returns an array containing synonymous standard font names corresponding to the name supplied
	 * @param fontName font's name
	 * @return synonymous standard font names
	 */
	public static String[] getStandardFontNames(ASName fontName)
	{
		ASName standardFontProperName = standardFontsNames.get(fontName);
		if(standardFontProperName != null)
		{
			if(standardFontProperName == ASName.k_Times_Roman)
			{
				return timesFamilyNames;
			}
			else if(standardFontProperName == ASName.k_Times_Bold)
			{
				return timesBoldFamilyNames;
			}
			else if(standardFontProperName == ASName.k_Times_Italic)
			{
				return timesItalicFamilyNames;
			}
			else if(standardFontProperName == ASName.k_Times_BoldItalic)
			{
				return timesBoldItalicFamilyNames;
			}
			else if(standardFontProperName == ASName.k_Helvetica)
			{
				return helveticaFamilyNames;
			}
			else if(standardFontProperName == ASName.k_Helvetica_Bold)
			{
				return helveticaBoldFamilyNames;
			}
			else if(standardFontProperName == ASName.k_Helvetica_Oblique)
			{
				return helveticaItalicFamilyNames;
			}
			else if(standardFontProperName == ASName.k_Helvetica_BoldOblique)
			{
				return helveticaBoldItalicFamilyNames;
			}
			else if(standardFontProperName == ASName.k_Courier)
			{
				return courierFamilyNames;
			}
			else if(standardFontProperName == ASName.k_Courier_Bold)
			{
				return courierBoldFamilyNames;
			}
			else if(standardFontProperName == ASName.k_Courier_Oblique)
			{
				return courierItalicFamilyNames;
			}
			else if(standardFontProperName == ASName.k_Courier_BoldOblique)
			{
				return courierBoldItalicFamilyNames;
			}
			else if(standardFontProperName == ASName.k_Symbol)
			{
				return symbolFamilyNames;
			}
			else if(standardFontProperName == ASName.k_ZapfDingbats)
			{
				return zapfDingbatsFamilyNames;
			}
		}
		return null;
	}
}
