/* ****************************************************************************
*
*	File: SecurityLock.java
*
* ****************************************************************************
*
*	ADOBE CONFIDENTIAL
*	___________________
*
*	Copyright 2003-2005 Adobe Systems Incorporated
*	All Rights Reserved.
*
*	NOTICE: All information contained herein is, and remains the property of
*	Adobe Systems Incorporated and its suppliers, if any. The intellectual
*	and technical concepts contained herein are proprietary to Adobe Systems
*	Incorporated and its suppliers and may be covered by U.S. and Foreign
*	Patents, patents in process, and are protected by trade secret or
*	copyright law. Dissemination of this information or reproduction of this
*	material is strictly forbidden unless prior written permission is obtained
*	from Adobe Systems Incorporated.
*
* ***************************************************************************/

package com.adobe.internal.pdftoolkit.core.securityframework;


import java.util.Map;

/**
 * Provides the functionality to (optionally) encrypt a PDFDocument at full save time.
 * <P><code>SecurityLock</code> is composed of three attributes:</P>
 * <UL> 
 *    <LI>Security Manager for encryption  </LI> 
 *    <LI>Encryption Parameters Map  </LI>
 *    <LI>Requested permissions  </LI>
 * </UL>
 * <P>Each of these attributes is represented by an object of an appropriate type.
 * Different implementations of the SecurityLock instantiate these attributes 
 * according to the rules of specific implementations.</P>
 * 
 * <P>Use {@link com.adobe.internal.pdftoolkit.core.securityframework.SecurityKey#getSecurityManager()} 
 * to decrypt the document.</P>
 */
public interface SecurityLock 
{
	/**
	 * Return the Security Manager that contains Security Handlers used to encrypt a PDF document.</P>
	 * @return a <code>SecurityManager</code> object. May return <code>null</code>.
	 */
	public SecurityManager getSecurityManager();
	
	/**
	 * Set the encryption parameter map that reflects the content of the /Encrypt dictionary
	 * used to encrypt a PDF document.
	 * <P>This <code>Map</code> uses the following correspondence 
	 * between PDF Types and Java Objects:</P>
	 * 
	 * <p>
	 * <table border='1' cellspacing='0'>
	 * <tbody>
	 * <tr><td>CosBoolean</td><td>Boolean</td></tr>
	 * <tr><td>CosNumeric</td><td>Number</td></tr>
	 * <tr><td>CosName</td><td>String</td></tr>
	 * <tr><td>CosString</td><td>Byte array</td></tr>
	 * <tr><td>CosArray</td><td>ArrayList</td></tr>
	 * <tr><td>CosDictionary</td><td>HashMap</td></tr>
	 * </tbody>
	 * </table>
	 * @param encryptParams the encryption parameters.
	 */
	public void setEncryptParameters(Map encryptParams);
	
	/**
	 * Determine whether the saved PDF document should be encrypted.
	 * The absence of encryption is one of the encryption choices.
	 * This method tells the user of the security lock implementation whether the saved 
	 * PDF document should be encrypted.
	 * @return <code>true</code> if this document should be encrypted; 
	 * <code>false</code>, otherwise.
	 */
	public boolean shouldEncrypt();

	/**
	 * Get the encryption parameters map used for encryption. 
	 * <P>This <code>Map</code> uses the same correspondence 
	 * between PDF Types and Java Objects as in the {@link #setEncryptParameters(Map)} method.</P>
	 * @return a <CODE>Map</CODE> that contains encryption parameters. May return <code>null</code>.
	 */
	public Map getEncryptParameters();	
}
