/* ****************************************************************************
*
*	File: SecurityLockPasswordInterface.java
*
* ****************************************************************************
*
*	ADOBE CONFIDENTIAL
*	___________________
*
*	Copyright 2003-2005 Adobe Systems Incorporated
*	All Rights Reserved.
*
*	NOTICE: All information contained herein is, and remains the property of
*	Adobe Systems Incorporated and its suppliers, if any. The intellectual
*	and technical concepts contained herein are proprietary to Adobe Systems
*	Incorporated and its suppliers and may be covered by U.S. and Foreign
*	Patents, patents in process, and are protected by trade secret or
*	copyright law. Dissemination of this information or reproduction of this
*	material is strictly forbidden unless prior written permission is obtained
*	from Adobe Systems Incorporated.
*
* ***************************************************************************/

package com.adobe.internal.pdftoolkit.core.securityframework.impl;

import java.util.Map;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.permissionprovider.PermissionProvider;
import com.adobe.internal.pdftoolkit.core.securityframework.SecurityLock;
import com.adobe.internal.pdftoolkit.core.securityframework.SecurityManager;

/**
 * Use this factory to create security locks compatible with a specific (<I>or greater than</I>) 
 * version of Adobe Acrobat. Each instance of this class is document-specific. </P>
 * <P><B>Note</B>: When the abstract methods declared in this class are implemented
 * by the user, they will be contained in the objects that <code>newInstance()</code> methods return. </P>
 * @author itenenbo
 */
public interface SecurityLockPasswordInterface extends SecurityLock
{
	
	
	abstract public SecurityLockPasswordInterface makeSecurityLock(byte[] owner, byte[] user, 
						Map encryptParams, PermissionProvider encryptionPermissions, SecurityProvidersImpl providers) 
    throws PDFSecurityException;
    
	abstract public SecurityManager getSecurityManager();
	
}
