/* ****************************************************************************
 *
 *	File: AbstractRefAdapter.java
 *
 * ****************************************************************************
 *
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2010 Adobe Systems Incorporated
 *	All Rights Reserved.
 *
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is obtained
 *	from Adobe Systems Incorporated.
 *
 * ***************************************************************************/
package com.adobe.internal.pdftoolkit.core.util;

/**
 * This is an abstract class to keep a reference of an object.
 * @author hkansal
 *
 */
public abstract class AbstractRefAdapter<T>{
	
	protected T objectRef;
	
	/**
	 * returns Object wrapped inside.
	 */
	public T getObject(){
		return objectRef;
	}
	
	@Override
	public abstract boolean equals(Object obj);
	
	@Override
	public int hashCode() {
		return objectRef.hashCode();
	}
	
		
}
