/* ****************************************************************************
 *
 *	File: StringOps.java
 *
 * ****************************************************************************
 *
 *	ADOBE CONFIDENTIAL
 *	___________________
 *
 *	Copyright 2006 Adobe Systems Incorporated
 *	All Rights Reserved.
 *
 *	NOTICE: All information contained herein is, and remains the property of
 *	Adobe Systems Incorporated and its suppliers, if any. The intellectual
 *	and technical concepts contained herein are proprietary to Adobe Systems
 *	Incorporated and its suppliers and may be covered by U.S. and Foreign
 *	Patents, patents in process, and are protected by trade secret or
 *	copyright law. Dissemination of this information or reproduction of this
 *	material is strictly forbidden unless prior written permission is obtained
 *	from Adobe Systems Incorporated.
 *
 * ***************************************************************************/

// @author itenenbo

package com.adobe.internal.pdftoolkit.core.util;

import java.nio.ByteBuffer;

public class StringOps
{

	private StringOps()
	{
	}

	public static byte[] convertFromHex(String hexStr)
	{
		byte[] converted = new byte[hexStr.length() / 2];
		int numBytes = 0;
		int charInd = 0;
		int b1 = -1;
		int b2 = -1;
		boolean first = true;
		while (charInd < hexStr.length())
		{
			if (first)
			{
				b1 = Character.digit(hexStr.charAt(charInd++), 16);
				if (b1 != -1)
				{
					first = false;
				}
			}
			else
			{
				b2 = Character.digit(hexStr.charAt(charInd++), 16);
				if (b2 != -1)
				{
					first = true;
					converted[numBytes++] = (byte) ((b1 << 4) | b2);
				}
			}
		}
		return numBytes > 0 ? ByteBuffer.wrap(converted, 0, numBytes).array() : null;
	}

	public static boolean isASCII(String str)
	{
		int strInd;
		for (strInd = 0; strInd < str.length(); strInd++)
		{
			char curChar = str.charAt(strInd);
            if ((curChar > 127) || ((curChar < 32) && !ByteOps.isWhitespace(curChar))) 
                return false; // TODO; enhance the test
		}
		return true;
	}
	
	/**
	 * Turns a String into a byte array.
	 * This method makes many, MANY assumptions on the nature of the data.
	 * Not all of which are valid.
	 * @param s the string to be written
	 */
	public static byte[] toByteArray(String s)
	{
		byte[] bytes = new byte[s.length()];
		for (int i = 0; i < s.length(); ++i)
		{
			bytes[i] = (byte) s.charAt(i);
		}
		return bytes;
	}
}
