package com.adobe.internal.pdftoolkit.core.util;

import java.nio.charset.Charset;

/**
 * This class provides some utility methods related to UTF-8 encoding.
 * @author hkansal
 *
 */
public class UTF8Support extends UTFSupport {
	
	static private Charset utf8Encoding = Charset.forName(UTF8);
	
	/**
	 * Converts the string to UTF-8 format.
	 */
	public static byte[] toUTF8(String uniStr)
	{
		if (uniStr == null) return null;
		byte[] utf8Bytes = utf8Encoding.encode(uniStr).array();
		return trimTrailingZeros(utf8Bytes, false);
	}
}
