/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.reef.siren;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * A {@code Field} represents a control inside an {@link Action}.
 */
public final class Field {
    
    private String name;
    
    private FieldType type = FieldType.TEXT;
    
    private String value;
    
    private String title;

    private boolean optional = false;

    private boolean multi = false;

    public Field(String name) {
        this.name = name;
    }

    /**
     * Returns the name attribute.
     * 
     * @return the name
     */
    public String getName() {
        return name;
    }

    /**
     * Sets the name attribute.
     * 
     * @param name the name to set
     */
    public void setName(String name) {
        this.name = name;
    }

    /**
     * Returns the type attribute.
     * 
     * @return the type
     */
    public FieldType getType() {
        return type;
    }

    /**
     * Sets the type attribute.
     * 
     * @param type the type to set
     */
    public void setType(FieldType type) {
        this.type = type;
    }

    /**
     * Returns the value attribute.
     * 
     * @return the value
     */
    public String getValue() {
        return value;
    }

    /**
     * Sets the value attribute.
     * 
     * @param value the value to set
     */
    public void setValue(String value) {
        this.value = value;
    }

    /**
     * Returns the title attribute.
     * 
     * @return the title
     */
    public String getTitle() {
        return title;
    }

    /**
     * Sets the title attribute.
     * 
     * @param title the title to set
     */
    public void setTitle(String title) {
        this.title = title;
    }

    /**
     * Returns the optional attribute
     * @return The optional attribute
     */
    public boolean getOptional() {
        return optional;
    }

    /**
     * Sets the optional attribute.
     * @param optional Whether the field should be considered optional
     */
    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    /**
     * Returns the multi attribute
     * @return The multi attribute
     */
    public boolean isMulti() {
        return multi;
    }

    /**
     * Sets the multi attribute
     * @param multi Whether the field can contain multiple values
     */
    public void setMulti(boolean multi) {
        this.multi = multi;
    }

    @Override
    public String toString() {
        try {
            JSONObject field = new JSONObject();
            field.put("name", name);
            if (type != null) {
                field.put("type", type.toString().toLowerCase());
            }
            if (title != null) {
                field.put("title", title);
            }
            if (optional) {
                field.put("optional", optional);
            }
            if (multi) {
                field.put("multi", multi);
            }
            if (value != null) {
                field.put("value", value);
            }
            return field.toString();
        } catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((name == null) ? 0 : name.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (obj == null) return false;
        if (getClass() != obj.getClass()) return false;
        Field other = (Field) obj;
        if (name == null) {
            if (other.name != null) return false;
        } else if (!name.equals(other.name)) return false;
        return true;
    }

    public enum FieldType {
        BUTTON, 
        CHECKBOX, 
        COLOR, 
        DATE, 
        DATETIME, 
        DATETIMELOCAL, 
        EMAIL, 
        FILE, 
        HIDDEN, 
        IMAGE, 
        MONTH, 
        NUMBER, 
        PASSWORD, 
        RADIO, 
        RANGE, 
        RESET, 
        SEARCH, 
        SUBMIT, 
        TEL, 
        TEXT, 
        TIME, 
        URL, 
        WEEK;
    }

}
