/*************************************************************************
 *
 * ADOBE CONFIDENTIAL
 * __________________
 *
 *  Copyright 2014 Adobe Systems Incorporated
 *  All Rights Reserved.
 *
 * NOTICE:  All information contained herein is, and remains
 * the property of Adobe Systems Incorporated and its suppliers,
 * if any.  The intellectual and technical concepts contained
 * herein are proprietary to Adobe Systems Incorporated and its
 * suppliers and are protected by trade secret or copyright law.
 * Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained
 * from Adobe Systems Incorporated.
 **************************************************************************/
package com.adobe.reef.siren.builder;

import com.adobe.reef.siren.Link;

/**
 * {@code LinkBuilder} is a {@link Builder} implementation for {@link Link}.
 */
public class LinkBuilder extends Builder<Link> {

    private String href;

    private String[] rel;

    private String title;

    private String type;

    public LinkBuilder() {

    }

    public LinkBuilder setHref(String href) {
        this.href = href;
        return this;
    }

    public LinkBuilder setRel(String[] rel) {
        this.rel = rel;
        return this;
    }

    public LinkBuilder setTitle(String title) {
        this.title = title;
        return this;
    }

    public LinkBuilder setType(String type) {
        this.type = type;
        return this;
    }

    public LinkBuilder clear() {
        rel = null;
        href = null;
        title = null;
        type = null;
        return this;
    }

    public Link doBuild() throws BuilderException {
        try {
            Link link = new Link(rel, href);
            link.setTitle(title);
            link.setType(type);
            return link;
        } catch (IllegalArgumentException e) {
            throw new BuilderException(e.getMessage(), e);
        }
    }

    protected void validate(Link link) throws BuilderValidationException {
        if (link.getHref() == null || link.getRel() == null) {
            throw new BuilderValidationException("href and rel cannot be null or empty.");
        }
    }

}
