/***************************************************************************/
/*                                                                         */
/*                      ADOBE CONFIDENTIAL                                 */
/*                      _ _ _ _ _ _ _ _ _ _                                */
/*                                                                         */
/*  Copyright 2006, Adobe Systems Incorporated                             */
/*  All Rights Reserved.                                                   */
/*                                                                         */
/*  NOTICE: All information contained herein is, and remains the property  */
/*  of Adobe Systems Incorporated and its suppliers, if any.  The          */
/*  intellectual and technical concepts contained herein are proprietary   */
/*  to Adobe Systems Incorporated and its suppliers and may be coveredby   */
/*  U.S. and Foreign Patents, patents in process, and are protected by     */
/*  trade secret or copyright law.  Dissemination of this information or   */
/*  reproduction of this material is strictly forbidden unless prior       */
/*  written permission is obtained from Adobe Systems Incorporated.        */
/*                                                                         */
/***************************************************************************/

package com.adobe.versioncue.nativecomm;

import com.adobe.versioncue.nativecomm.msg.INCExternalizable;

/**
 * @author <a href="mailto:tnaroska@adobe.com">tnaroska</a>
 * @version $Revision: #1 $
 * @since Mar 7, 2006
 */
public class ServiceTimeoutException extends NativeCommException
{
	// -------------------------------------------------------------------------- Public Constructor

	/**  UID */
	private static final long serialVersionUID = 8049028480967038366L;

	/**
	 * Constructor for ServiceTimeoutException.
	 * 
	 * @param message detail message
	 */
	public ServiceTimeoutException(String message)
	{
		super(message);
	}

	/**
	 * Constructor for NativeCommException.
	 * 
	 * @param request the failed request data
	 */
	public ServiceTimeoutException(INCExternalizable request)
	{
		super("Request timed out: " + request);
	}
}