/***************************************************************************/
/*                                                                         */
/*                      ADOBE CONFIDENTIAL                                 */
/*                      _ _ _ _ _ _ _ _ _ _                                */
/*                                                                         */
/*  Copyright 2009, Adobe Systems Incorporated                             */
/*  All Rights Reserved.                                                   */
/*                                                                         */
/*  NOTICE: All information contained herein is, and remains the property  */
/*  of Adobe Systems Incorporated and its suppliers, if any. The           */
/*  intellectual and technical concepts contained herein are proprietary   */
/*  to Adobe Systems Incorporated and its suppliers and may be covered by  */
/*  U.S. and Foreign Patents, patents in process, and are protected by     */
/*  trade secret or copyright law.  Dissemination of this information or   */
/*  reproduction of this material is strictly forbidden unless prior       */
/*  written permission is obtained from Adobe Systems Incorporated.        */
/*                                                                         */
/***************************************************************************/

package com.adobe.versioncue.nativecomm.host;

import com.adobe.versioncue.nativecomm.NativeCommException;
import com.adobe.versioncue.nativecomm.ServiceCallException;

/**
 * @author  <a href="mailto:tnaroska@adobe.com">tnaroska</a>
 * @version $Revision$
 * @since   CS5
 */
public interface IHostDelegate
{
	/** @return a unique identifier */
	String identifier();

	/**
	 * Called when a new client connects. If a single client opens multiple connections this
	 * method is only called once for the first connection.
	 * 
	 * @param host - the INCommHost instance
	 * @param client - ncomm client
	 */
	void clientConnected(INCommHost host, IClient client);

	/**
	 * Called to process a received ncomm request.
	 * The delegate can retrieve ncomm parameters from the passed request object and set results.
	 * If an error should be signaled to the ncomm client throw a ServiceCallException specifying
	 * an error code and message.
	 * Progress updates can be sent to the client using
	 * {@link IRequest#setProgress(String, double)}. This method can also be used to allow the
	 * ncomm client to abort the request.
	 *  
	 * @param host - the INCommHost instance
	 * @param request - ncomm request object
	 * 
	 * @throws ServiceCallException - if an error should be signaled to the ncomm client
	 * @throws NativeCommException - if an unexpected error occurs
	 */
	void execute(INCommHost host, IRequest request)
		throws ServiceCallException, NativeCommException;

	/**
	 * Called when a client disconnects. If a single client opens multiple connections this
	 * method is only called once when all the client's connections are closed.
	 *  
	 * @param host - the INCommHost instance
	 * @param client - ncomm client
	 */
	void clientDisconnected(INCommHost host, IClient client);

	/**
	 * Called if a ncomm request handler encounters an exception.
	 * Useful for logging.
	 *
	 * @param host - the INCommHost instance
	 * @param e - the error
	 */
	void ncommError(INCommHost host, Throwable e);
}