/***************************************************************************/
/*                                                                         */
/*                      ADOBE CONFIDENTIAL                                 */
/*                      _ _ _ _ _ _ _ _ _ _                                */
/*                                                                         */
/*  Copyright 2006, Adobe Systems Incorporated                             */
/*  All Rights Reserved.                                                   */
/*                                                                         */
/*  NOTICE: All information contained herein is, and remains the property  */
/*  of Adobe Systems Incorporated and its suppliers, if any.  The          */
/*  intellectual and technical concepts contained herein are proprietary   */
/*  to Adobe Systems Incorporated and its suppliers and may be coveredby   */
/*  U.S. and Foreign Patents, patents in process, and are protected by     */
/*  trade secret or copyright law.  Dissemination of this information or   */
/*  reproduction of this material is strictly forbidden unless prior       */
/*  written permission is obtained from Adobe Systems Incorporated.        */
/*                                                                         */
/***************************************************************************/

package com.adobe.versioncue.nativecomm.msg;

/**
 * @author <a href="mailto:tnaroska@adobe.com">Timo Naroska</a>
 * @version $Revision: #1 $
 */
public final class NCLong extends NCNumber
{
	// --------------------------------------------------------------------------- Private Variables

	/** long value */
	private final long value;

	// -------------------------------------------------------------------------- Public Constructor

	/**
	 * Public constructor
	 * 
	 * @param value long value
	 */
	public NCLong(long value)
	{
		this.value = value;
	}

	// ------------------------------------------------------------------------------ Public Methods

	@Override
	public double doubleValue()
	{
		return value;
	}

	@Override
	public int intValue()
	{
		return (int) value;
	}

	@Override
	public long longValue()
	{
		return value;
	}

	@Override
	public int getType()
	{
		return NCType.TYPE_LONG;
	}

	@Override
	public int hashCode()
	{
		return (int) (value ^ (value >>> 32));
	}

	@Override
	public String toString()
	{
		return "NCLong <" + value + ">";
	}
}
