/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa;


/**
 * This class contains all the script functionality associated with the
 * AppModel class.  Broken out into a separate class for easier maintainability.
 *
 * @exclude from published api.
 */
public class AppModelScript extends ElementScript {

	static final ScriptTable moScriptTable = new ScriptTable(
		ModelScript.moScriptTable,
		"xfa", 
		new ScriptPropObj[] {
			new ScriptPropObj(AppModelScript.class, "this", "getThis", null, Arg.OBJECT, Schema.XFAVERSION_10, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_THIS_DESC, 0*/, 0),
			new ScriptPropObj(AppModelScript.class, "timeStamp", "getTimeStamp", "setTimeStamp", Arg.STRING, Schema.XFAVERSION_10, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_TIMESTAMP_DESC, 0*/, 0),
			new ScriptPropObj(AppModelScript.class, "uuid", "getUUID", "setUUID", Arg.STRING, Schema.XFAVERSION_10, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_UUID_DESC, 0*/, 0)
		},
		null
	);
	
	public static ScriptTable getScriptTable() {
		return moScriptTable;
	}
	
	public static void getThis(Obj  pObj,Arg  oRetVal)	{
		// getContext is implemented in Model.  "this" is
		// an alias for "context" for an AppModel
		oRetVal.setObject(((AppModel)pObj).getContext());
	}

	public static void getTimeStamp(Obj  pObj,Arg  oRetVal) {
		oRetVal.setString(((AppModel)pObj).getAttribute(XFA.TIMESTAMPTAG).toString());
	}
	public static void getUUID(Obj  pObj,Arg  oRetVal)	{
		oRetVal.setString(((AppModel)pObj).getAttribute(XFA.UUIDTAG).toString());
	}

	public static void setTimeStamp(Obj  pObj, Arg oArg) {
		((AppModel)pObj).setAttribute(new StringAttr(XFA.TIMESTAMP, oArg.getString()),XFA.TIMESTAMPTAG);
	}

	public static void setUUID(Obj  pObj, Arg oArg) {
		((AppModel)pObj).setAttribute(new StringAttr(XFA.UUID, oArg.getString()),XFA.UUIDTAG);
	}
	
	public static boolean getPseudoModelFunc(Obj pObj, Arg oRetVal, String sProp) {
		// Don't allow xfa to be returned as an apparent child of xfa!
		if (sProp == null || sProp.equals(XFA.XFA))
			return false;

		String pseudoRootName = "$" + sProp;
		
		// Check to see if it's a shorthand notation for $log or $host or other
		// pseudo-models.
		Obj oPseudoModel = ((AppModel)pObj).lookupPseudoModel(pseudoRootName);
		if (oPseudoModel != null) {
			if (oRetVal != null)
				oRetVal.setObject(oPseudoModel);
			
			return true;
		}

		// Check to see if it's a shorthand notation for $data or $template or other
		// pseudo-root nodes (i.e. xfa.data or xfa.template, etc.)
		Node pseudoRoot = Model.lookupShortCut((Model)pObj, pseudoRootName);
		if (pseudoRoot != null) {
			if (oRetVal != null)
				oRetVal.setObject(pseudoRoot);
			
			return true;
		}

		return false;
	}
}
