/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa;

/**
 *
 * @exclude from published api -- Mike Tardif, May 2006.
 */
public final class AppSchema extends Schema {
	/**
	 * Default constructor
	 */
	AppSchema() {
		super(STRS.XDP_NAMESPACE,
				XFA.XFA_ATTRIBUTE_MIN, 
				XFA.XFA_ATTRIBUTE_MAX, 
				XFA.XFA_ELEMENT_MIN, 
				XFA.XFA_ELEMENT_MAX);
		initSchema();
	}

	/**
	 * If we're using this version of getInstance, it's because there is no model to
	 * define this element.  Therefore, create a simple element node.
	 */
	public Element	getInstance(String className,
								Model model,
								Element parent, Node prevSibling) {
		
		Element e = new Element(parent, prevSibling, null, className);
		return e;
	}
	
	protected Element newElement(int eTag, Element parent, Node prevSibling) {
		
		// This is never called becase AppSchema overrides Schema.getInstance(int, Model, Element)
		
		return null;
	}

	
}
