/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa;


/**
 * A class to...
 *
 * @exclude from published api.
 */
public final class ChildRelnInfo {
	public ChildRelnInfo(ChildReln relationship, int nVersionIntro,
			int nVersionDep, int nAvailability, int descriptionResID) {
		mDescriptionResID = descriptionResID;
		mnVersionIntro = nVersionIntro;
		mnVersionDep = nVersionDep;
		mnAvailability = nAvailability;
		mRelationship = relationship;
	}

	private final int mDescriptionResID;

	private final int mnVersionIntro;

	private final int mnVersionDep;

	private final int mnAvailability;

	private final ChildReln mRelationship;

	public int getDescription() {
		return mDescriptionResID;
	}

	public int getVersionIntroduced() {
		return mnVersionIntro;
	}

	public int getVersionDeprecated() {
		return mnVersionDep;
	}

	public int getAvailability() {
		return mnAvailability;
	}

	public ChildReln getRelationship() {
		return mRelationship;
	}
}
