/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2007 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa;


/**
 * This class contains all the script functionality associated with the
 * Delta class.  Broken out into a separate class for easier maintainability.
 *
 * @exclude from published api.
 */
public class DeltaScript extends ObjScript {

	protected static final ScriptTable moScriptTable = new ScriptTable(
		ObjScript.moScriptTable,
		"delta", 
		new ScriptPropObj[] {
			new ScriptPropObj(DeltaScript.class, "parent", "getParent", null, Arg.OBJECT, Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN /*, XFA_IS_DELTA_PARENT_DESC, 0*/, 0),
			new ScriptPropObj(DeltaScript.class, "target", "getTarget", null, Arg.STRING, Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN /*, XFA_IS_DELTA_TARGET_DESC, 0*/, 0),
			new ScriptPropObj(DeltaScript.class, "savedValue", "getSavedValue", null, Arg.STRING, Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN /*, XFA_IS_DELTA_SAVEDVALUE_DESC, 0*/, 0),
			new ScriptPropObj(DeltaScript.class, "currentValue", "getCurrentValue", null, Arg.STRING, Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN /*, XFA_IS_DELTA_CURRENTVALUE_DESC, 0*/, 0)
		},
		new ScriptFuncObj[] {
			new ScriptFuncObj(DeltaScript.class, "restore", "restore", Arg.EMPTY, new int[] { }, 0, Schema.XFAVERSION_25, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN /*, XFA_IS_DELTA_RESTORE_DESC, null, null*/, 0)
		}
	);
	
	public static ScriptTable getScriptTable() {
		return moScriptTable;
	}

	public static void getParent(Obj pObj, Arg oRetVal) {
		oRetVal.setObject(((Delta) pObj).getParent());
	}

	public static void getTarget(Obj  pObj, Arg oRetVal) {
		oRetVal.setString(((Delta) pObj).getTarget());
	}

	public static void getSavedValue(Obj pObj, Arg oRetVal) {
		oRetVal.setString(((Delta) pObj).getSavedValue());
	}

	public static void getCurrentValue(Obj pObj, Arg oRetVal) {
		oRetVal.setString(((Delta) pObj).getCurrentValue());
	}

	public static void restore(Obj pObj, Arg oRetVal, Arg[] pArgs) {
		((Delta) pObj).restore();
	}

}
