/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa;

/**
 * DependencyTracker is a pure virtual class used to determine dependencies
 * of executing scripts.  Certain key points throughout the code will call
 * addDependency when they determine that the currently-executing code depends
 * on a particular XFAObject.  A DependencyTracker is registered with the
 * AppModel.
 *
 * @exclude from published api -- Mike Tardif, May 2006.
 */
public abstract class DependencyTracker {
	public abstract void	addDependency(Obj poDependsOnImpl);
	public abstract void	addVirtualDependency(Obj oObj, String sPropertyName);
}
