/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa;

import com.adobe.xfa.EventManager.EventID;
import com.adobe.xfa.ut.Peer;
import com.adobe.xfa.ut.PeerImpl;

/**
 * @exclude from public api.
 */
public abstract class Dispatcher implements Peer {
	
	private boolean mbIsOccurring; // true if event is occurring right now

	private boolean mbIsRecurring; // true if event repeats; false if event is one-shot
	
	private boolean mbListenToDescendents;

	private final int mnEventID;

	private PeerImpl mPeers;

	private final Element mpoActionContextNode;

	private Obj mpoEventContextObject;

	private EventManager mpoEventManager;

	private final String msEventContext;
	

	public Dispatcher(Element poActionContextNode, String sEventContext,
			int nEventID, EventManager poEventManager) {
		mpoActionContextNode = poActionContextNode;
		//mpoEventContextObject = null;
		mpoEventManager = poEventManager;
		mnEventID = nEventID;
		mbIsRecurring = true;
		//mbIsOccurring = false;

		mpoActionContextNode.addPeer(this);

		// Also add the model as a peer, so that we'll be notified when it goes
		// away. Nodes with dead models are in a bad state. Fixes vantive 667231.
		Model poModelImpl = mpoActionContextNode.getModel();
		if (mpoActionContextNode != poModelImpl)
			poModelImpl.addPeer(this);

		if (sEventContext.equals("$")) {
			mpoEventContextObject = mpoActionContextNode;
			sEventContext = "";
		}
		
		msEventContext = sEventContext;
	}

	public void addPeer(Peer peerNode) {
		if (mPeers == null) {
			mPeers = new PeerImpl(this);
		}
		
		mPeers.addPeer(peerNode);
	}

	public void addPeeredNode(Peer peer) {
		if (mPeers == null) {
			mPeers = new PeerImpl(this);
		}
		
		mPeers.addPeeredNode(peer);
	}
	
	public void clearPeers() {
		if (mPeers != null)
			mPeers.clearPeers();
	}
	
	public void deafen() {
		if (mPeers == null) {
			mPeers = new PeerImpl(this);
		}
		
		mPeers.deafen();
	}

	protected abstract void dispatch();

	public Element getActionContextNode() {
		return mpoActionContextNode;
	}

	public abstract String getDispatcherType();;

	public String getEventContext() {
		return msEventContext;
	}

	public Obj getEventContextObj() {
		return mpoEventContextObject;
	}

	public int getEventID() {
		return mnEventID;
	}

	public EventManager getEventManager() {
		return mpoEventManager;
	}
	
	public boolean getListenToDescendents() {
		return mbListenToDescendents;
	}

	public boolean getOccurring() {
		return mbIsOccurring;
	}

	// getParameter is optional. A dispatcher may provide string responses
	// based on the parameter index. This is a private protocol used
	// only by external DLLs implementing the callout interface
	// (such as xfascriptmonitor).
	public String getParameter(int nParam) {
		return "";
	}

	/**
	 * return the requested peer
	 * 
	 * @param nPeer -
	 *            the 0-based position of the peer to retrieve.
	 * @return the peer at the requested position. When there are not more
	 *         peers to return, this will return a null object.
	 */
	public Peer getPeer(int nPeer /* =0 */) {
		if (mPeers == null) {
			return null;
		}
		return mPeers.getPeer(nPeer);
	}

	public boolean getRecurring() {
		return mbIsRecurring;
	}

	public boolean isDeaf() {
		if (mPeers == null) {
			return false;
		}
		return mPeers.isDeaf();
	}

	public boolean isMute() {
		if (mPeers == null) {
			return false;
		}
		return mPeers.isMute();
	}

	public void mute() {
		if (mPeers == null) {
			mPeers = new PeerImpl(this);
		}
		mPeers.mute();
	}

	public void notifyPeers(int eventType, String arg1, Object arg2) {
		if (mPeers != null) {
			mPeers.notifyPeers(eventType, arg1, arg2);
		}
	}

	public void peerRemoved(Peer peer) {
		// Check if event manager has been deleted.
		if (mpoEventManager == null)
			return;

		int nEventId = getEventID();
		assert (nEventId < mpoEventManager.getNumEventIDs());
		EventID events = mpoEventManager.getEventIDByIndex(nEventId);

		Obj object = getEventContextObj();

		// go through the object dispatchers and remove this dispatcher
		// Note that if pObject is the same as pPeer, then pObject seems to be invalid
		// and cannot be dereferenced. This problem was found when a subform's initialize
		// script removed the subform instance
		if (object != null && object != peer) {
			// remove the dispatcher from the eventTable
			EventManager.EventTable eventTable = object.getEventTable(false);

			if (eventTable != null) {
				eventTable.remove(this);
			}
		} else {
			// removed "this" from uninitialized events list
			for (int i = 0; i < events.mUnInitializedEvents.size(); i++) {
				Dispatcher dispatcher = events.mUnInitializedEvents.get(i);
				if (this == dispatcher) {
					events.mUnInitializedEvents.remove(i);
					break;
				}
			}
		}

	}

	/**
	 * Remove a peer node from the notification list.
	 * 
	 * @param oPeerNode -
	 *            The reference to the peer object to be removed.
	 */
	public void removePeer(Peer oPeerNode) {
		if (mPeers == null) {
			return;
		}
		mPeers.removePeer(oPeerNode);
	}

	public void removePeeredNode(Peer poPeer) {
		if (mPeers == null) {
			return;
		}
		mPeers.removePeeredNode(poPeer);
	}

	public void setEventContextObj(Obj poObject) {
		mpoEventContextObject = poObject;
	}

	public void setEventManager(EventManager poEventManager) {
		mpoEventManager = poEventManager;
	}
	
	public void setListenToDescendents(boolean bListenToDescendents) {
		mbListenToDescendents = bListenToDescendents;
	}

	public void setOccurring(boolean bOccurring) {
		mbIsOccurring = bOccurring;
	}

	// specifies that a dispatcher is recurring (the default is true).
	// Recurring dispatchers remain active indefinitely.
	public void setRecurring(boolean bRecurring) {
		mbIsRecurring = bRecurring;
	}

	// Dispatcher

	public void unDeafen() {
		if (mPeers == null) {
			return;
		}
		mPeers.unDeafen();
	}

	public void unMute() {
		if (mPeers == null) {
			return;
		}
		mPeers.unMute();
	}

	public void updateFromPeer(Object oPeerNode, int eventType, String arg1, Object arg2) {
		// Do nothing
	}
}