/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */

package com.adobe.xfa;

/**
 * Class LogMessageHandlerStore stores LogMessages in an internal collection
 * so that they may be retrieved at a later time.
 *
 * @exclude from published api.
 */
public class LogMessageHandlerStore extends LogMessageHandler {
	
	@Override
	public void clearMessages() {
		getMessages().clear();
	}
	
	@Override
	public boolean supportsRead() {
		return true;
	}

	@Override
	public void flush() {
		// do nothing
	}

	@Override
	public void sendMessage(LogMessage message) {
		getMessages().add(message);
	}
}
