/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2007 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa;


/**
 * This class contains all the script functionality associated with the
 * Manifest class.  Broken out into a separate class for easier maintainability.
 *
 * @exclude from published api.
 */
public class ManifestScript extends ProtoableNodeScript {

	protected static final ScriptTable moScriptTable = new ScriptTable(
		ProtoableNodeScript.moScriptTable,
		"manifest",
		new ScriptPropObj[] {
			new ScriptPropObj(ManifestScript.class, null, "getObject", null, Arg.OBJECT, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_PLUGIN /*, XFA_IS_MANIFEST_DESC, XFA_IS_MANIFEST_DESC */, 0)
		},
		new ScriptFuncObj[] {
			new ScriptFuncObj(ManifestScript.class, "evaluate", "evaluate", Arg.EMPTY, new int[] { }, 0, Schema.XFAVERSION_21, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_PLUGIN /*, XFA_IS_MANIFEST_EVALUATE_DESC, XFA_IS_MANIFEST_EVALUATE_RET, null*/, 0),
			new ScriptFuncObj(ManifestScript.class, "execValidate", "execValidate", Arg.BOOL, new int[] { }, 0, Schema.XFAVERSION_28, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_PLUGIN /*, XFA_IS_MANIFEST_EXECVALIDATE_DESC, XFA_IS_MANIFEST_EXECVALIDATE_RET, NULL*/, 0),
			new ScriptFuncObj(ManifestScript.class, "execCalculate", "execCalculate", Arg.EMPTY, new int[] { }, 0, Schema.XFAVERSION_28, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_PLUGIN /*, XFA_IS_MANIFEST_EXECCALCULATE_DESC, 0, NULL*/, 0),
			new ScriptFuncObj(ManifestScript.class, "execInitialize", "execInitialize", Arg.EMPTY, new int[] { }, 0, Schema.XFAVERSION_28, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_PLUGIN /*, XFA_IS_MANIFEST_EXECINITIALIZE_DESC, 0, NULL*/, 0)
		}
	);
	
	public static ScriptTable getScriptTable() {
		return moScriptTable;
	}

	public static void getObject(Obj obj, Arg retVal) {
		retVal.setObject(obj);
	}

	public static void evaluate(Obj obj, Arg retVal, Arg[] args) {
		retVal.setObject(((Manifest)obj).doEvaluate());
	}
	
	public static void execValidate(Obj obj, Arg retVal, Arg[] args) {
		retVal.setBool(((Manifest)obj).doExecValidate());
	}

	public static void execCalculate(Obj obj, Arg retVal, Arg[] args) {
		((Manifest)obj).doExecCalculate();
	}
	
	public static void execInitialize(Obj obj, Arg retVal, Arg[] args) {
		((Manifest)obj).doExecInitialize();
	}
}
