/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2007 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa;


import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.MsgFormatPos;
import com.adobe.xfa.ut.ResId;


/**
 * This class contains all the script functionality associated with the
 * Model class.  Broken out into a separate class for easier maintainability.
 *
 * @exclude from published api.
 */
public class ModelScript extends ElementScript {

	protected static final ScriptTable moScriptTable = new ScriptTable(
		ElementScript.moScriptTable,
		"model",
		new ScriptPropObj[] {
			new ScriptPropObj(ModelScript.class, "aliasNode", "getAliasNode", "setSliasNode", Arg.OBJECT, Schema.XFAVERSION_10, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_ALIASNODE_DESC, 0*/, 0),
			new ScriptPropObj(ModelScript.class, "context", "getContext", "setContext", Arg.OBJECT, Schema.XFAVERSION_10, Schema.XFAAVAILABILITY_DEPRECATED/*, XFA_IS_CONTEXT_DESC, 0*/, Schema.XFAVERSION_22),
			new ScriptPropObj(ModelScript.class, "name", "getName", "setName", Arg.STRING, Schema.XFAVERSION_10, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_NAME, 0*/, 0)
		},

		new ScriptFuncObj[] {
			new ScriptFuncObj(ModelScript.class, "createNode", "createNode", Arg.OBJECT,
				new int[] { Arg.STRING, Arg.STRING, Arg.STRING/*, XFA_IS_CREATENODE_PARAM1, XFA_IS_CREATENODE_PARAM2, XFA_IS_CREATENODE_PARAM3*/ }, 1, Schema.XFAVERSION_10, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_CREATENODE_DESC, XFA_IS_CREATENODE_RET, null*/, 0),
			new ScriptFuncObj(ModelScript.class, "clearErrorList", "clearErrorList", Arg.EMPTY,
				new int[] { }, 0, Schema.XFAVERSION_10, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_CLEARERRORLIST_DESC, 0, null*/, 0),
			new ScriptFuncObj(ModelScript.class, "isCompatibleNS", "isCompatibleNS", Arg.BOOL,
				new int[] { Arg.STRING/*, XFA_IS_ISCOMPATIBLENS_PARAM1*/ }, 1, Schema.XFAVERSION_10, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_ISCOMPATIBLENS_DESC, 0, null*/, 0)
		}
	);


	public static void getAliasNode(Obj pObj, Arg oRetVal) {
		oRetVal.setObject(((Model) pObj).getAliasNode());
	}

	// we don't want to document this anymore it is anymore... don't really make sense in a scripting environment and could even be "dangerous" to use.
	// changed the availability to deprecated
	public static void getContext(Obj pObj, Arg oRetVal) {
		oRetVal.setObject(((Model) pObj).getContext());
	}

	public static void setAliasNode(Obj pObj, Arg oArg) {
		// check object type
		Obj oObject = oArg.getObject();
		if (! (oObject instanceof Element))
			throw new ExFull(ResId.ArgumentMismatchException);
		((Model) pObj).setAliasNode((Element) oObject);
	}

	public static void getName(Obj pObj, Arg oRetVal) {
		oRetVal.setString(((Model) pObj).getName());
	}

	public static void setContext(Obj pObj, Arg oArg) {
		// check object type
		Obj oObject = oArg.getObject();
		if (! (oObject instanceof Node))
			throw new ExFull(ResId.ArgumentMismatchException);
		((Model) pObj).setContext((Node) oObject);
	}

	public static void setName(Obj pObj, Arg oArg) {
		// disallow this on a model (i.e. prevent this from getting to XFANodeImpl)
		MsgFormatPos oMessage = new MsgFormatPos(ResId.InvalidSetPropertyException);
		oMessage.format(((Model) pObj).getClassAtom()).format(XFA.NAME);
		throw new ExFull(oMessage);
	}

	public static void createNode(Obj pObj, Arg oRetVal, Arg[] pArgs) {
		String aTagName = pArgs[0].getString();
		if (aTagName != null)
			aTagName = aTagName.intern();
		int eTag = XFA.getTag(aTagName);
		if (eTag != -1) {
			if (pArgs.length == 1)
				oRetVal.setObject(((Model) pObj).createNode(eTag, null, "", "", true));
			else if (pArgs.length == 2)
				oRetVal.setObject(((Model) pObj).createNode(eTag, null, pArgs[1].getString(), "", true));
			else if (pArgs.length == 3)
				oRetVal.setObject(((Model) pObj).createNode(eTag, null, pArgs[1].getString(), pArgs[2].getString(), true));
		}
	}

	public static void clearErrorList(Obj pObj, Arg oRetVal, Arg[] pArgs) {
		((Model) pObj).clearErrorList();
	}

	public static void isCompatibleNS(Obj pObj, Arg oRetVal, Arg[] pArgs) {
		String aNS = pArgs[0].getString();
		oRetVal.setBool(Boolean.valueOf(((Model) pObj).isCompatibleNS(aNS)));
	}

	public static ScriptTable getScriptTable() {
		return moScriptTable;
	}
}
