/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */ package com.adobe.xfa;


/**
 * This class contains all the script functionality associated with the
 * Node class.  Broken out into a separate class for easier maintainability.
 *
 * @exclude from published api.
 */
public class NodeScript extends ObjScript {

	protected static final ScriptTable moScriptTable = new ScriptTable(
		ObjScript.moScriptTable,
		"node",
		new ScriptPropObj[] {
			new ScriptPropObj(NodeScript.class, "nodes", "getNodes", null, Arg.OBJECT, Schema.XFAVERSION_10, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_GETNODES, 0*/, 0),
			new ScriptPropObj(NodeScript.class, "name", "getName", "setName", Arg.STRING, Schema.XFAVERSION_10, Schema.XFAAVAILABILITY_ALL/*, XFA_IS_NAME, 0*/, 0),
			new ScriptPropObj(NodeScript.class, "parent", "getParent", null, Arg.OBJECT, Schema.XFAVERSION_10, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_GETPARENT, 0*/, 0),
			new ScriptPropObj(NodeScript.class, "index", "getIndex", null, Arg.INTEGER, Schema.XFAVERSION_10, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_PLUGIN/* * ,XFA_IS_GETINDEX_DESC, 0*/, 0),
			new ScriptPropObj(NodeScript.class, "classIndex", "classIndex", null, Arg.INTEGER, Schema.XFAVERSION_10, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_GETCLASSINDEX_DESC, 0*/, 0),
			new ScriptPropObj(NodeScript.class, "all", "getAll", null, Arg.OBJECT, Schema.XFAVERSION_10, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_GETALL_DESC, 0*/, 0),
			new ScriptPropObj(NodeScript.class, "classAll", "classAll", null, Arg.OBJECT, Schema.XFAVERSION_10, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_GETCLASSALL_DESC, 0*/, 0),
			new ScriptPropObj(NodeScript.class, "somExpression", "getSomExpression", null, Arg.STRING, Schema.XFAVERSION_10, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_GETSOMEXPRESSION, 0*/, 0),
			new ScriptPropObj(NodeScript.class, "isContainer", "isContainer", null, Arg.BOOL, Schema.XFAVERSION_10, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_ISCONTAINER_DESC, XFA_IS_ISCONTAINER_RET*/, 0),
			new ScriptPropObj(NodeScript.class, "model", "getModel", null, Arg.OBJECT, Schema.XFAVERSION_10, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_GETMODEL, 0*/, 0)
		},
		new ScriptFuncObj[] {
			new ScriptFuncObj(NodeScript.class, "resolveNode", "resolveNode", Arg.OBJECT,
				new int[] { Arg.STRING /*, XFA_IS_RESOLVENODE_PARAM*/ }, 1, Schema.XFAVERSION_10, Schema.XFAAVAILABILITY_ALL/*, XFA_IS_RESOLVENODE_DESC, XFA_IS_RESOLVENODE_RET*/, 0),
			new ScriptFuncObj(NodeScript.class, "resolveNodes", "resolveNodes", Arg.OBJECT,
				new int[] { Arg.STRING /*, XFA_IS_RESOLVENODES_PARAM*/ }, 1, Schema.XFAVERSION_10, Schema.XFAAVAILABILITY_ALL/*, XFA_IS_RESOLVENODE_DESC, XFA_IS_RESOLVENODES_RET*/, 0)
		}
	);
	
	public static ScriptTable getScriptTable() {
		return moScriptTable;
	}


	public static void classAll(Obj pObj, Arg oRetVal) {
		oRetVal.setObject(((Node) pObj).getAll(false),false, true);
	}

	public static void classIndex(Obj pObj, Arg oRetVal) {
		oRetVal.setInteger(Integer.valueOf(((Node) pObj).getIndex(false)));
	}

	public static void getAll(Obj pObj, Arg oRetVal) {
		oRetVal.setObject(((Node) pObj).getAll(true),false,true);
	}

	public static void getIndex(Obj pObj, Arg oRetVal) {
		oRetVal.setInteger(Integer.valueOf(((Node) pObj).getIndex(true)));
	}

	public static void getModel(Obj pObj, Arg oRetVal) {
		oRetVal.setObject(((Node) pObj).getModel());
	}

	public static void getName(Obj pObj, Arg oRetVal) {
		oRetVal.setString(((Node) pObj).getName());
	}

	public static void getNodes(Obj pObj, Arg oRetVal) {
		oRetVal.setObject(((Node) pObj).getNodes(),false, true);
	}

	public static void getParent(Obj pObj, Arg oRetVal) {
		oRetVal.setObject(((Node) pObj).getXFAParent(), false, true);
	}

	public static void getSomExpression(Obj pObj, Arg oRetVal) {
		oRetVal.setString(((Node) pObj).getSOMExpression());
	}

	public static void isContainer(Obj pObj, Arg oRetVal) {
		oRetVal.setBool(Boolean.valueOf(((Node) pObj).isContainer()));
	}

	public static void setName(Obj pObj, Arg oArg) {
		((Node) pObj).setName(oArg.getString());
	}

	
	public static void resolveNode(Obj pObj, Arg oRetVal, Arg[] pArgs) {
		oRetVal.setObject(((Node) pObj).resolveNode(pArgs[0].getString()));
	}

	public static void resolveNodes(Obj pObj, Arg oRetVal, Arg[] pArgs) {
		oRetVal.setObject(((Node) pObj).resolveNodes(pArgs[0].getString(), false, false, false));
	}
	
	
	// ------------------------------------------------------------------------
	// Utilities used by Node.getDynamicScriptProp
	
	/**
	 * 
	 * @param n
	 * @param sChildName If non-null, this String must be interned.
	 * @param bByName
	 * @return a child node, or null.
	 */
	static Node getScriptChild(Node n, String sChildName, boolean bByName) {
		
		if (sChildName == null)
			return null;

		// first check children of this node for the named node
		Node child = n.getFirstXFAChild();
		while (child != null) {
			boolean	bMatch = false;
			if (bByName)
			 	bMatch = (sChildName.equals(child.getName()));
			else
				bMatch = (sChildName.equals(child.getClassAtom()));
			
			if ( bMatch ) {
				int eType = Element.INVALID;
				if (n instanceof Element)
					eType = ((Element) n).getSchemaType(child.getClassTag());
				
				// not a property
				if (eType == Element.CHILD || eType == Element.ONEOF)
					return child;
			}
			if (child instanceof Element && child.isTransparent()) {
				// if the child is transparent, treat its children as if they
				// were at the same level as the child.
				Node retval = getScriptChild(child, sChildName, bByName);
				if (retval != null)
					return retval; // found the one we're looking for
			}
			child = child.getNextXFASibling();
		}
		return null;
	}
	
	public static boolean scriptPropLocateChildByClass(Obj obj, Arg retVal, String sChildName) {
		if (!(obj instanceof Element))
			return false;
		
		Node oChild = getScriptChild((Node)obj, sChildName, false);
		if (oChild == null)
			return false;

		retVal.setObject(oChild);
		return true;
	}

	public static boolean scriptPropLocateChildByName(Obj obj, Arg retVal, String sChildName) {
		if (!(obj instanceof Element))
			return false;
		
		Node oChild = getScriptChild((Node)obj, sChildName, true);
		if (oChild == null)
			return false;

		retVal.setObject(oChild);
		return true;
	}
}
