/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa;


/**
 * This class contains all the script functionality associated with the
 * Obj class.  Broken out into a separate class for easier maintainability.
 *
 * @exclude from published api.
 */
public class ObjScript {

	protected static final ScriptTable moScriptTable = new ScriptTable(
		null,
		"object",
		new ScriptPropObj[] { 
			new ScriptPropObj(ObjScript.class, "className", "getClassName", null, Arg.STRING, Schema.XFAVERSION_10, Schema.XFAAVAILABILITY_CORE | Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_GETCLASSNAME, 0*/, 0)
		},
    	null
	);

	public static void getClassName(Obj pThis, Arg oRetVal) {
		oRetVal.setString(pThis.getClassAtom());
	}

	public static ScriptTable getScriptTable() {
		return moScriptTable;
	}

    /**
     * Permissions checking functions for script calls or declarative operations
     * @param obj the object to check
     * @return TRUE if ok to modify, else FALSE
     * @exclude from published api.
	 */
	public static boolean setPropPermsCheck(Obj obj) {
		if (obj instanceof Node) {
			if (!((Node)obj).checkAncestorPerms())
				return false;
		}
		
		return true;
	}
}
