/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */

package com.adobe.xfa;

import com.adobe.xfa.ut.FindBugsSuppress;

/**
 * This table holds the list of script property and function methods
 * available for this class.
 *
 * <h4><a name="immutability">Immutability</a></h4>
 * ScriptTable objects are immutable.
 *
 * @exclude from published api -- Mike Tardif, May 2006.
 */

public final class ScriptTable {
	final ScriptTable 	mParentClass;
	@FindBugsSuppress(code="UrF")
	final String 			msName;				// the className - used for debugging only
	final ScriptPropObj[] mPropTable;
	final ScriptFuncObj[] mFuncTable;
	
	@FindBugsSuppress(code="EI2")	
	public ScriptTable(ScriptTable parent, String sName, ScriptPropObj[] propTable, ScriptFuncObj[] funcTable) {
		mParentClass	= parent;
		msName			= sName;
		mPropTable		= propTable;
		mFuncTable 		= funcTable;
	}
}
