/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */

package com.adobe.xfa;

import java.util.ArrayList;
import java.util.List;

/**
 * This class is used to implement script-able list objects that are not node lists.
 * This class combined with ListBase are the equivalent of the C++ XFAListImpl
 *
 * @exclude from published api.
 */
public final class XFAList extends ListBase {
	private final List<Obj> mArray;

	/**
	 * default constructor
	 */
	public XFAList() {
		mArray = new ArrayList<Obj>();
	}

	/**
	 * Create a new XFAList
	 * @param list
	 *            to clone
	 */
	public XFAList(List<? extends Obj> list, boolean bReadOnly) {
		super(bReadOnly);
		mArray = new ArrayList<Obj>(list);
	}

	/**
	 * @see ListBase#append(Obj)
	 */
	public void append(Obj listObj) {
		mArray.add(listObj);
	}

	/**
	 * @see ListBase#insert(Obj, Obj)
	 */
	public void insert(Obj newNode, Obj refNode) {
		for (int i = 0; i < mArray.size(); i++) {
			if (mArray.get(i) == refNode) {
				mArray.add(i, newNode);
			}
		}
	}

	/**
	 * @see ListBase#item(int)
	 */
	public Obj item(int index) {
		return mArray.get(index);
	}

	/**
	 * @see ListBase#length()
	 */
	public int length() {
		return mArray.size();
	}

	/**
	 * @see ListBase#remove(Obj)
	 */
	public void remove(Obj removeNode) {
		mArray.remove(removeNode);
	}
	
	/* @exclude from published api. */
	boolean appendPermsCheck() {
		return true;
	}
	
	/* @exclude from published api. */
	boolean removePermsCheck(Obj obj) {
		return true;
	}
	
	/* @exclude from published api. */
	boolean insertPermsCheck() {
		return true;
	}
}