/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.configuration;


import org.xml.sax.Attributes;

import com.adobe.xfa.AppModel;
import com.adobe.xfa.Element;
import com.adobe.xfa.ModelFactory;
import com.adobe.xfa.Model;
import com.adobe.xfa.ModelPeer;
import com.adobe.xfa.Node;
import com.adobe.xfa.STRS;
import com.adobe.xfa.XFA;


/**
 * A class to represent XFA configuration model factories. 
 * A configuration model factory is used by an application model
 * to create a configuration model where appropriate,
 * when loading an XML file.
 *
 * @author Ian Benedict Carreon
 * @author Mike Tardif (ported to Java)
 */
public final class ConfigurationModelFactory extends ModelFactory {

	/**
	 * Instantiates a configuration model factory. 
	 */
	public ConfigurationModelFactory() {
		super(XFA.CONFIGTAG, XFA.CONFIG, STRS.DOLLARCONFIG);
	}


	/**
 	 * @exclude from published api.
	 */
	protected Model	newModel(AppModel parent, Node prevSibling, String uri,
							 String localName, String qName,
							 Attributes attrs) {
		ConfigurationModel cm = new ConfigurationModel(parent, prevSibling);
		cm.setXmlPeer(new ModelPeer(
				(Element)parent.getXmlPeer(), null, 
				uri, localName, qName, 
				attrs, cm));
		cm.setDOMProperties(uri, localName, qName, attrs);
		
		return cm;
	}
	
	/**
 	 * @exclude from published api.
	 */
	public Model createDOM(Element parent) {
		
		ConfigurationModel cm = new ConfigurationModel(parent.getAppModel(), null);
		
		ModelPeer modelPeer = new ModelPeer(
				parent, null, 
				ConfigurationModel.configurationNS(), XFA.CONFIG, XFA.CONFIG, 
				null, cm);
		
		cm.setXmlPeer(modelPeer);
		cm.connectPeerToDocument();
				
		return cm;
	}
	
	/**
	 * ConfigModel knows how to merge a duplicate model into an existing one
	 * during postLoad processing.
	 * @exclude from published api.
	 */
	public boolean getAllowAdd() {
		return true;
	}
}
