/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2007 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.configuration;


import com.adobe.xfa.Arg;
import com.adobe.xfa.Attribute;
import com.adobe.xfa.Obj;
import com.adobe.xfa.Schema;
import com.adobe.xfa.ScriptPropObj;
import com.adobe.xfa.ScriptTable;


/**
 * This class contains all the script functionality associated with the
 * ConfigurationUri class.  Broken out into a separate class for easier maintainability.
 *
 * @exclude from published api.
 */
public class ConfigurationUriScript extends ConfigurationElementScript {

	protected static final ScriptTable moScriptTable = new ScriptTable(
		ConfigurationElementScript.moScriptTable,
		"configurationUri",
		new ScriptPropObj[] {
			new ScriptPropObj(ConfigurationUriScript.class, "value", "getValue", "setValue", Arg.STRING, Schema.XFAVERSION_10, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_CONFIGURI_VALUE, 0 */, 0),
			new ScriptPropObj(ConfigurationUriScript.class,  null, "getValue", "setValue", Arg.STRING, Schema.XFAVERSION_10, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_CONFIGURI_VALUE, 0 */, 0),
			new ScriptPropObj(ConfigurationUriScript.class, "file", "getFile", null, Arg.STRING, Schema.XFAVERSION_10, Schema.XFAAVAILABILITY_CORE|Schema.XFAAVAILABILITY_PLUGIN/*, XFA_IS_CONFIGURI_GETFILE, 0 */, 0)
		},
		null
	);
	
	public static ScriptTable getScriptTable() {
		return moScriptTable;
	}

	public static void getValue(Obj pObj, Arg oRetVal) {
		oRetVal.setString(((ConfigurationUri) pObj).getValue(null).toString());
	}

	public static void setValue(Obj pObj, Arg propertyValue) {
		String oValue = propertyValue.getString();
		Attribute oAttr = ((ConfigurationUri) pObj).getValue(null);
		((ConfigurationUri) pObj).setValue(oAttr.newAttribute(oValue));
	}

	public static void getFile(Obj pObj, Arg oRetVal) {
//		jfFileId oFileId;
//		((ConfigurationUri) pObj).getFile(oFileId);
//		oRetVal.setString(oFileId.FileName());
	}

}
