/*
 * ADOBE CONFIDENTIAL
 *
 * Copyright 2005 Adobe Systems Incorporated All Rights Reserved.
 *
 * NOTICE: All information contained herein is, and remains the property of
 * Adobe Systems Incorporated and its suppliers, if any. The intellectual and
 * technical concepts contained herein are proprietary to Adobe Systems
 * Incorporated and its suppliers and may be covered by U.S. and Foreign
 * Patents, patents in process, and are protected by trade secret or copyright
 * law. Dissemination of this information or reproduction of this material
 * is strictly forbidden unless prior written permission is obtained from
 * Adobe Systems Incorporated.
 */
package com.adobe.xfa.connectionset;


import org.xml.sax.Attributes;

import com.adobe.xfa.AppModel;
import com.adobe.xfa.Element;
import com.adobe.xfa.ModelFactory;
import com.adobe.xfa.Model;
import com.adobe.xfa.ModelPeer;
import com.adobe.xfa.Node;
import com.adobe.xfa.STRS;
import com.adobe.xfa.XFA;
import com.adobe.xfa.connectionset.proxies.ConnectionSetProxy;
import com.adobe.xfa.ut.Storage;


/**
 * A class to represent XFA connectionset model factories. 
 * A connectionset model factory is used by an application model
 * to create a connectionset model where appropriate,
 * when loading an XML file.
 */
public final class ConnectionSetModelFactory extends ModelFactory {
    
    final Storage<ConnectionSetProxy>   mProxyArray = new Storage<ConnectionSetProxy>();

	/**
	 * Instantiates a connectionset model factory. 
	 */
	public ConnectionSetModelFactory() {
		super(XFA.CONNECTIONSETTAG, XFA.CONNECTIONSET, STRS.DOLLARCONNECTIONSET);
	}

	/**
 	 * @exclude from published api.
	 */
	public Model createDOM(Element parent) {
		
		ConnectionSetModel model = new ConnectionSetModel(parent.getAppModel(), null);
		
		ModelPeer modelPeer = new ModelPeer(
				parent, null, 
				ConnectionSetModel.connectionSetNS(), XFA.CONNECTIONSET, XFA.CONNECTIONSET, 
				null, model);
		
		model.setXmlPeer(modelPeer);
		model.connectPeerToDocument();
		
		for (int i = 0; i < model.mProxyArray.size(); i++) {
        	model.registerProxy(model.mProxyArray.get(i));
        }
		
		return model;
	}

	/**
 	 * @exclude from published api.
	 */
	protected Model	newModel(AppModel parent, Node prevSibling, String uri,
							 String localName, String qName,
							 Attributes attrs) {
		ConnectionSetModel oModel = new ConnectionSetModel(parent, prevSibling);
		oModel.setXmlPeer(new ModelPeer(
				(Element)parent.getXmlPeer(), null, 
				uri, localName, qName, 
				attrs, oModel));
        for (int i = 0; i < oModel.mProxyArray.size(); i++) {
        	((ConnectionSetModel) oModel).registerProxy(oModel.mProxyArray.get(i));
        }
		oModel.setDOMProperties(uri, localName, qName, attrs);

		return oModel;
	}

	/**
 	 * @exclude from published api.
	 */
	public void registerProxy(ConnectionSetProxy oProxy) {
	    mProxyArray.add(oProxy.clone());
	}

}
